/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.configuration;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.worker.BackoffSupplier;
import io.camunda.spring.client.annotation.customizer.JobWorkerValueCustomizer;
import io.camunda.spring.client.configuration.AnnotationProcessorConfiguration;
import io.camunda.spring.client.configuration.CamundaBeanPostProcessorConfiguration;
import io.camunda.spring.client.configuration.CamundaClientConfigurationImpl;
import io.camunda.spring.client.configuration.JsonMapperConfiguration;
import io.camunda.spring.client.jobhandling.CamundaClientExecutorService;
import io.camunda.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.DefaultJobExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.JobExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.JobWorkerManager;
import io.camunda.spring.client.jobhandling.parameter.DefaultParameterResolverStrategy;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.spring.client.jobhandling.result.DefaultResultProcessorStrategy;
import io.camunda.spring.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.spring.client.metrics.MetricsRecorder;
import io.camunda.spring.client.properties.CamundaClientProperties;
import io.camunda.spring.client.properties.PropertyBasedJobWorkerValueCustomizer;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobClient;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(prefix="camunda.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={AnnotationProcessorConfiguration.class, JsonMapperConfiguration.class, CamundaBeanPostProcessorConfiguration.class})
@EnableConfigurationProperties(value={CamundaClientProperties.class})
public class CamundaClientAllAutoConfiguration {
    private final CamundaClientProperties camundaClientProperties;

    public CamundaClientAllAutoConfiguration(CamundaClientProperties camundaClientProperties) {
        this.camundaClientProperties = camundaClientProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public CamundaClientExecutorService camundaClientExecutorService() {
        return CamundaClientExecutorService.createDefault(Optional.ofNullable(this.camundaClientProperties.getExecutionThreads()).orElse(CamundaClientConfigurationImpl.DEFAULT.getNumJobWorkerExecutionThreads()));
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandExceptionHandlingStrategy commandExceptionHandlingStrategy(CamundaClientExecutorService scheduledExecutorService) {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), scheduledExecutorService.get());
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterResolverStrategy parameterResolverStrategy(JsonMapper jsonMapper, @Autowired(required=false) ZeebeClient zeebeClient) {
        return new DefaultParameterResolverStrategy(jsonMapper, (JobClient)zeebeClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public ResultProcessorStrategy resultProcessorStrategy() {
        return new DefaultResultProcessorStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public JobExceptionHandlingStrategy jobExceptionHandlingStrategy(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder) {
        return new DefaultJobExceptionHandlingStrategy(commandExceptionHandlingStrategy, metricsRecorder);
    }

    @Bean
    public JobWorkerManager jobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy, BackoffSupplier backoffSupplier, JobExceptionHandlingStrategy jobExceptionHandlingStrategy) {
        return new JobWorkerManager(commandExceptionHandlingStrategy, metricsRecorder, parameterResolverStrategy, resultProcessorStrategy, backoffSupplier, jobExceptionHandlingStrategy);
    }

    @Bean
    @ConditionalOnMissingBean
    public BackoffSupplier backoffSupplier() {
        return BackoffSupplier.newBackoffBuilder().build();
    }

    @Bean(value={"propertyBasedJobWorkerValueCustomizer"})
    @ConditionalOnMissingBean(name={"propertyBasedJobWorkerValueCustomizer"})
    public JobWorkerValueCustomizer propertyBasedJobWorkerValueCustomizer() {
        return new PropertyBasedJobWorkerValueCustomizer(this.camundaClientProperties);
    }
}

