/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.spring.client.annotation.AnnotationUtil;
import io.camunda.spring.client.annotation.customizer.JobWorkerValueCustomizer;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.bean.MethodInfo;
import io.camunda.spring.client.bean.ParameterInfo;
import io.camunda.spring.client.properties.CamundaClientJobWorkerProperties;
import io.camunda.spring.client.properties.CamundaClientProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class PropertyBasedJobWorkerValueCustomizer
implements JobWorkerValueCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBasedJobWorkerValueCustomizer.class);
    private final CamundaClientProperties camundaClientProperties;

    public PropertyBasedJobWorkerValueCustomizer(CamundaClientProperties camundaClientProperties) {
        this.camundaClientProperties = camundaClientProperties;
    }

    @Override
    public void customize(JobWorkerValue jobWorkerValue) {
        this.applyDefaultWorkerName(jobWorkerValue);
        this.applyDefaultJobWorkerType(jobWorkerValue);
        this.applyDefaultJobWorkerTenantIds(jobWorkerValue);
        this.applyFetchVariables(jobWorkerValue);
        this.applyOverrides(jobWorkerValue);
    }

    private void applyFetchVariables(JobWorkerValue jobWorkerValue) {
        if (this.hasActivatedJobInjected(jobWorkerValue)) {
            LOG.debug("Worker '{}': ActivatedJob is injected, no variable filtering possible", (Object)jobWorkerValue.getName());
        } else if (jobWorkerValue.getForceFetchAllVariables() != null && jobWorkerValue.getForceFetchAllVariables().booleanValue()) {
            LOG.debug("Worker '{}': Force fetch all variables is enabled", (Object)jobWorkerValue.getName());
            jobWorkerValue.setFetchVariables(List.of());
        } else {
            ArrayList<String> variables = new ArrayList<String>();
            if (jobWorkerValue.getFetchVariables() != null) {
                variables.addAll(jobWorkerValue.getFetchVariables());
            }
            if (this.camundaClientProperties.getWorker().getDefaults().getFetchVariables() != null) {
                variables.addAll(this.camundaClientProperties.getWorker().getDefaults().getFetchVariables());
            }
            variables.addAll(this.readZeebeVariableParameters(jobWorkerValue.getMethodInfo()).stream().map(this::extractVariableName).toList());
            variables.addAll(this.readVariablesAsTypeParameters(jobWorkerValue.getMethodInfo()));
            jobWorkerValue.setFetchVariables(variables.stream().distinct().toList());
            LOG.debug("Worker '{}': Fetching only required variables {}", (Object)jobWorkerValue.getName(), variables);
        }
    }

    private boolean hasActivatedJobInjected(JobWorkerValue jobWorkerValue) {
        return jobWorkerValue.getMethodInfo().getParameters().stream().anyMatch(p -> p.getParameterInfo().getType().isAssignableFrom(ActivatedJob.class));
    }

    private List<ParameterInfo> readZeebeVariableParameters(MethodInfo methodInfo) {
        return AnnotationUtil.getVariableParameters(methodInfo);
    }

    private String extractVariableName(ParameterInfo parameterInfo) {
        return AnnotationUtil.getVariableValue(parameterInfo).get().getName();
    }

    private List<String> readVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<String> result = new ArrayList<String>();
        List<ParameterInfo> parameters = AnnotationUtil.getVariablesAsTypeParameters(methodInfo);
        parameters.forEach(pi -> ReflectionUtils.doWithFields(pi.getParameterInfo().getType(), f -> result.add(this.extractFieldName(f))));
        return result;
    }

    private String extractFieldName(Field field) {
        String value;
        if (field.isAnnotationPresent(JsonProperty.class) && StringUtils.isNotBlank((CharSequence)(value = field.getAnnotation(JsonProperty.class).value()))) {
            return value;
        }
        return field.getName();
    }

    private void applyOverrides(JobWorkerValue editedJobWorkerValue) {
        CamundaClientJobWorkerProperties defaults = this.camundaClientProperties.getWorker().getDefaults();
        if (defaults != null) {
            this.copyProperties(defaults, editedJobWorkerValue, OverrideSource.defaults);
        }
        String workerType = editedJobWorkerValue.getType();
        this.findWorkerOverride(workerType).ifPresent(jobWorkerValue -> {
            LOG.debug("Worker '{}': Applying overrides {}", (Object)workerType, jobWorkerValue);
            this.copyProperties((CamundaClientJobWorkerProperties)jobWorkerValue, editedJobWorkerValue, OverrideSource.worker);
        });
    }

    private Optional<CamundaClientJobWorkerProperties> findWorkerOverride(String type) {
        return Optional.ofNullable(this.camundaClientProperties.getWorker().getOverride().get(type));
    }

    private void copyProperties(CamundaClientJobWorkerProperties source, JobWorkerValue target, OverrideSource overrideSource) {
        if (overrideSource == OverrideSource.worker) {
            this.copyProperty("fetchVariables", overrideSource, source::getFetchVariables, target::setFetchVariables);
            this.copyProperty("type", overrideSource, source::getType, target::setType);
            this.copyProperty("name", overrideSource, source::getName, target::setName);
            this.copyProperty("tenantIds", overrideSource, source::getTenantIds, target::setTenantIds);
        }
        this.copyProperty("timeout", overrideSource, source::getTimeout, target::setTimeout);
        this.copyProperty("maxJobsActive", overrideSource, source::getMaxJobsActive, target::setMaxJobsActive);
        this.copyProperty("requestTimeout", overrideSource, source::getRequestTimeout, target::setRequestTimeout);
        this.copyProperty("pollInterval", overrideSource, source::getPollInterval, target::setPollInterval);
        this.copyProperty("autoComplete", overrideSource, source::getAutoComplete, target::setAutoComplete);
        this.copyProperty("enabled", overrideSource, source::getEnabled, target::setEnabled);
        this.copyProperty("streamEnabled", overrideSource, source::getStreamEnabled, target::setStreamEnabled);
        this.copyProperty("streamTimeout", overrideSource, source::getStreamTimeout, target::setStreamTimeout);
        this.copyProperty("forceFetchAllVariables", overrideSource, source::getForceFetchAllVariables, target::setForceFetchAllVariables);
        this.copyProperty("maxRetries", overrideSource, source::getMaxRetries, target::setMaxRetries);
    }

    private <T> void copyProperty(String propertyName, OverrideSource overrideSource, Supplier<T> getter, Consumer<T> setter) {
        T value = getter.get();
        if (value != null) {
            LOG.debug("Overriding property '{}' from source {}", (Object)propertyName, (Object)overrideSource);
            setter.accept(value);
        }
    }

    private void applyDefaultWorkerName(JobWorkerValue jobWorkerValue) {
        String defaultJobWorkerName = this.camundaClientProperties.getWorker().getDefaults().getName();
        if (StringUtils.isBlank((CharSequence)jobWorkerValue.getName())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerName)) {
                LOG.debug("Worker '{}': Setting name to default {}", (Object)jobWorkerValue.getName(), (Object)defaultJobWorkerName);
                jobWorkerValue.setName(defaultJobWorkerName);
            } else {
                String generatedJobWorkerName = jobWorkerValue.getMethodInfo().getBeanName() + "#" + jobWorkerValue.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting name to generated {}", (Object)jobWorkerValue.getName(), (Object)generatedJobWorkerName);
                jobWorkerValue.setName(generatedJobWorkerName);
            }
        }
    }

    private void applyDefaultJobWorkerType(JobWorkerValue jobWorkerValue) {
        String defaultJobWorkerType = this.camundaClientProperties.getWorker().getDefaults().getType();
        if (StringUtils.isBlank((CharSequence)jobWorkerValue.getType())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerType)) {
                LOG.debug("Worker '{}': Setting type to default {}", (Object)jobWorkerValue.getName(), (Object)defaultJobWorkerType);
                jobWorkerValue.setType(defaultJobWorkerType);
            } else {
                String generatedJobWorkerType = jobWorkerValue.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting type to generated {}", (Object)jobWorkerValue.getName(), (Object)generatedJobWorkerType);
                jobWorkerValue.setType(generatedJobWorkerType);
            }
        }
    }

    private void applyDefaultJobWorkerTenantIds(JobWorkerValue jobWorkerValue) {
        ArrayList<String> tenantIds = new ArrayList<String>(Optional.ofNullable(this.camundaClientProperties.getWorker().getDefaults().getTenantIds()).orElse(Collections.emptyList()));
        if (jobWorkerValue.getTenantIds() != null) {
            tenantIds.addAll(jobWorkerValue.getTenantIds());
        }
        if (StringUtils.isNotBlank((CharSequence)this.camundaClientProperties.getTenantId())) {
            tenantIds.add(this.camundaClientProperties.getTenantId());
        }
        if (!tenantIds.isEmpty()) {
            LOG.debug("Worker '{}': Setting tenantIds to {}", (Object)jobWorkerValue.getName(), tenantIds);
            jobWorkerValue.setTenantIds(tenantIds.stream().distinct().toList());
        }
    }

    private static enum OverrideSource {
        defaults,
        worker;

    }
}

