/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.annotation.value;

import io.camunda.spring.client.annotation.value.CamundaAnnotationValue;
import io.camunda.spring.client.bean.ClassInfo;
import java.util.List;
import java.util.Objects;

public final class DeploymentValue
implements CamundaAnnotationValue<ClassInfo> {
    private final List<String> resources;
    private final ClassInfo beanInfo;

    private DeploymentValue(List<String> resources, ClassInfo beanInfo) {
        this.resources = resources;
        this.beanInfo = beanInfo;
    }

    public List<String> getResources() {
        return this.resources;
    }

    @Override
    public ClassInfo getBeanInfo() {
        return this.beanInfo;
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.beanInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentValue that = (DeploymentValue)o;
        return Objects.equals(this.resources, that.resources) && Objects.equals(this.beanInfo, that.beanInfo);
    }

    public String toString() {
        return "DeploymentValue{resources=" + String.valueOf(this.resources) + ", beanInfo=" + String.valueOf(this.beanInfo) + "}";
    }

    public static DeploymentValueBuilder builder() {
        return new DeploymentValueBuilder();
    }

    public static final class DeploymentValueBuilder {
        private List<String> resources;
        private ClassInfo beanInfo;

        private DeploymentValueBuilder() {
        }

        public DeploymentValueBuilder resources(List<String> resources) {
            this.resources = resources;
            return this;
        }

        public DeploymentValueBuilder beanInfo(ClassInfo beanInfo) {
            this.beanInfo = beanInfo;
            return this;
        }

        public DeploymentValue build() {
            return new DeploymentValue(this.resources, this.beanInfo);
        }
    }
}

