/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.configuration;

import io.camunda.spring.client.configuration.CamundaClientConfigurationImpl;
import io.camunda.spring.client.jobhandling.CamundaClientExecutorService;
import io.camunda.spring.client.properties.CamundaClientProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnMissingBean(value={CamundaClientExecutorService.class})
public class ExecutorServiceConfiguration {
    private final CamundaClientProperties camundaClientProperties;

    public ExecutorServiceConfiguration(CamundaClientProperties camundaClientProperties) {
        this.camundaClientProperties = camundaClientProperties;
    }

    @Bean
    public CamundaClientExecutorService camundaClientThreadPool(@Autowired(required=false) MeterRegistry meterRegistry) {
        int executionThreads = this.camundaClientProperties.getExecutionThreads() == null ? CamundaClientConfigurationImpl.DEFAULT.getNumJobWorkerExecutionThreads() : this.camundaClientProperties.getExecutionThreads().intValue();
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(executionThreads);
        if (meterRegistry != null) {
            ExecutorServiceMetrics threadPoolMetrics = new ExecutorServiceMetrics((ExecutorService)threadPool, "zeebe_client_thread_pool", Collections.emptyList());
            threadPoolMetrics.bindTo(meterRegistry);
        }
        return new CamundaClientExecutorService(threadPool, true);
    }
}

