/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.jobhandling;

import io.camunda.client.api.command.CommandWithVariables;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.exception.JobError;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.spring.client.jobhandling.result.ResultProcessor;
import io.camunda.spring.client.jobhandling.result.ResultProcessorStrategy;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class JobHandlingUtil {
    private JobHandlingUtil() {
    }

    public static List<ParameterResolver> createParameterResolvers(ParameterResolverStrategy parameterResolverStrategy, JobWorkerValue workerValue) {
        return workerValue.getMethodInfo().getParameters().stream().map(parameterResolverStrategy::createResolver).toList();
    }

    public static ResultProcessor createResultProcessor(ResultProcessorStrategy resultProcessorStrategy, JobWorkerValue workerValue) {
        return resultProcessorStrategy.createProcessor(workerValue.getMethodInfo());
    }

    public static <T extends CommandWithVariables<T>> T applyVariables(Object variables, T command) {
        if (variables == null) {
            return command;
        }
        if (variables.getClass().isAssignableFrom(Map.class)) {
            return (T)((CommandWithVariables)command.variables((Map)variables));
        }
        if (variables.getClass().isAssignableFrom(String.class)) {
            return (T)((CommandWithVariables)command.variables((String)variables));
        }
        if (variables.getClass().isAssignableFrom(InputStream.class)) {
            return (T)((CommandWithVariables)command.variables((InputStream)variables));
        }
        return (T)((CommandWithVariables)command.variables(variables));
    }

    public static String createErrorMessage(JobError jobError) {
        return ExceptionUtils.getStackTrace((Throwable)jobError);
    }
}

