/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.jobhandling.parameter;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.spring.client.annotation.AnnotationUtil;
import io.camunda.spring.client.annotation.value.VariableValue;
import io.camunda.spring.client.bean.ParameterInfo;
import io.camunda.spring.client.jobhandling.parameter.ActivatedJobParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.CompatActivatedJobParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.CompatJobClientParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.CustomHeadersResolver;
import io.camunda.spring.client.jobhandling.parameter.JobClientParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolver;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.spring.client.jobhandling.parameter.VariableResolver;
import io.camunda.spring.client.jobhandling.parameter.VariablesAsTypeResolver;
import io.camunda.zeebe.client.api.worker.JobClient;

public class DefaultParameterResolverStrategy
implements ParameterResolverStrategy {
    protected final JsonMapper jsonMapper;
    private final JobClient jobClient;

    public DefaultParameterResolverStrategy(JsonMapper jsonMapper, JobClient jobClient) {
        this.jsonMapper = jsonMapper;
        this.jobClient = jobClient;
    }

    public DefaultParameterResolverStrategy(JsonMapper jsonMapper) {
        this(jsonMapper, null);
    }

    @Override
    public ParameterResolver createResolver(ParameterInfo parameterInfo) {
        Class<?> parameterType = parameterInfo.getParameterInfo().getType();
        if (JobClient.class.isAssignableFrom(parameterType)) {
            if (this.jobClient != null) {
                return new CompatJobClientParameterResolver(this.jobClient);
            }
            throw new IllegalStateException("Legacy JobClient is required for parameter " + String.valueOf(parameterInfo) + " of method " + String.valueOf(parameterInfo.getMethodInfo()));
        }
        if (io.camunda.zeebe.client.api.response.ActivatedJob.class.isAssignableFrom(parameterType)) {
            return new CompatActivatedJobParameterResolver();
        }
        if (io.camunda.client.api.worker.JobClient.class.isAssignableFrom(parameterType)) {
            return new JobClientParameterResolver();
        }
        if (ActivatedJob.class.isAssignableFrom(parameterType)) {
            return new ActivatedJobParameterResolver();
        }
        if (AnnotationUtil.isVariable(parameterInfo)) {
            VariableValue variableValue = AnnotationUtil.getVariableValue(parameterInfo).get();
            String variableName = variableValue.getName();
            boolean optional = variableValue.isOptional();
            return new VariableResolver(variableName, parameterType, this.jsonMapper, optional);
        }
        if (AnnotationUtil.isVariablesAsType(parameterInfo)) {
            return new VariablesAsTypeResolver(parameterType);
        }
        if (AnnotationUtil.isCustomHeaders(parameterInfo)) {
            return new CustomHeadersResolver();
        }
        throw new IllegalStateException("Could not create parameter resolver for parameter " + String.valueOf(parameterInfo));
    }
}

