/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import io.camunda.spring.client.properties.CamundaClientLegacyPropertiesMapping;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;

public class CamundaClientLegacyPropertiesMappingsLoader {
    public static List<CamundaClientLegacyPropertiesMapping> load() {
        Properties properties = new Properties();
        try (InputStream inputStream = CamundaClientLegacyPropertiesMappingsLoader.class.getClassLoader().getResourceAsStream("camunda-client-legacy-property-mappings.properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading legacy property mappings", e);
        }
        ArrayList<CamundaClientLegacyPropertiesMapping> mappings = new ArrayList<CamundaClientLegacyPropertiesMapping>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String propertyName = (String)key;
            String legacyPropertyNamesString = (String)value;
            List<String> legacyPropertyNames = Arrays.stream(legacyPropertyNamesString.split(",")).map(String::trim).toList();
            CamundaClientLegacyPropertiesMapping propertyMapping = new CamundaClientLegacyPropertiesMapping();
            propertyMapping.setPropertyName(propertyName);
            propertyMapping.setLegacyPropertyNames(legacyPropertyNames);
            mappings.add(propertyMapping);
        }));
        return mappings;
    }
}

