/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import io.camunda.client.impl.util.ClientPropertiesValidationUtils;
import io.camunda.spring.client.properties.CamundaClientAuthProperties;
import io.camunda.spring.client.properties.CamundaClientCloudProperties;
import io.camunda.spring.client.properties.CamundaClientDeploymentProperties;
import io.camunda.spring.client.properties.CamundaClientWorkerProperties;
import io.camunda.spring.client.properties.common.IdentityProperties;
import io.camunda.spring.client.properties.common.ZeebeClientProperties;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="camunda.client")
public class CamundaClientProperties {
    private Boolean enabled;
    private ClientMode mode;
    @Deprecated(forRemoval=true, since="8.8")
    private String clusterId;
    @Deprecated(forRemoval=true, since="8.8")
    private String region;
    @NestedConfigurationProperty
    private CamundaClientCloudProperties cloud = new CamundaClientCloudProperties();
    @Deprecated(forRemoval=true, since="8.8")
    @NestedConfigurationProperty
    private List<String> tenantIds = new ArrayList<String>();
    @NestedConfigurationProperty
    private CamundaClientAuthProperties auth = new CamundaClientAuthProperties();
    @NestedConfigurationProperty
    private IdentityProperties identity = new IdentityProperties();
    @NestedConfigurationProperty
    @Deprecated(forRemoval=true, since="8.8")
    private ZeebeClientProperties zeebe = new ZeebeClientProperties();
    private Integer executionThreads;
    private Duration messageTimeToLive;
    private DataSize maxMessageSize;
    private DataSize maxMetadataSize;
    private String caCertificatePath;
    private Duration keepAlive;
    private String overrideAuthority;
    @NestedConfigurationProperty
    private CamundaClientWorkerProperties worker = new CamundaClientWorkerProperties();
    private Boolean preferRestOverGrpc;
    private URI grpcAddress;
    private URI restAddress;
    @NestedConfigurationProperty
    private CamundaClientDeploymentProperties deployment = new CamundaClientDeploymentProperties();
    private String tenantId;
    private Duration requestTimeout;
    private Duration requestTimeoutOffset;

    public CamundaClientCloudProperties getCloud() {
        return this.cloud;
    }

    public void setCloud(CamundaClientCloudProperties cloud) {
        this.cloud = cloud;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Duration getRequestTimeoutOffset() {
        return this.requestTimeoutOffset;
    }

    public void setRequestTimeoutOffset(Duration requestTimeoutOffset) {
        this.requestTimeoutOffset = requestTimeoutOffset;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public CamundaClientWorkerProperties getWorker() {
        return this.worker;
    }

    public void setWorker(CamundaClientWorkerProperties worker) {
        this.worker = worker;
    }

    public Integer getExecutionThreads() {
        return this.executionThreads;
    }

    public void setExecutionThreads(Integer executionThreads) {
        this.executionThreads = executionThreads;
    }

    public Duration getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    public void setMessageTimeToLive(Duration messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    public String getCaCertificatePath() {
        return this.caCertificatePath;
    }

    public void setCaCertificatePath(String caCertificatePath) {
        this.caCertificatePath = caCertificatePath;
    }

    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    public void setOverrideAuthority(String overrideAuthority) {
        this.overrideAuthority = overrideAuthority;
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public DataSize getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    public void setMaxMetadataSize(DataSize maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
    }

    public Boolean getPreferRestOverGrpc() {
        return this.preferRestOverGrpc;
    }

    public void setPreferRestOverGrpc(Boolean preferRestOverGrpc) {
        this.preferRestOverGrpc = preferRestOverGrpc;
    }

    public URI getGrpcAddress() {
        return this.grpcAddress;
    }

    public void setGrpcAddress(URI grpcAddress) {
        ClientPropertiesValidationUtils.checkIfUriIsAbsolute((URI)grpcAddress, (String)"grpcAddress");
        this.grpcAddress = grpcAddress;
    }

    public URI getRestAddress() {
        return this.restAddress;
    }

    public void setRestAddress(URI restAddress) {
        ClientPropertiesValidationUtils.checkIfUriIsAbsolute((URI)restAddress, (String)"restAddress");
        this.restAddress = restAddress;
    }

    public CamundaClientDeploymentProperties getDeployment() {
        return this.deployment;
    }

    public void setDeployment(CamundaClientDeploymentProperties deployment) {
        this.deployment = deployment;
    }

    public ClientMode getMode() {
        return this.mode;
    }

    public void setMode(ClientMode mode) {
        this.mode = mode;
    }

    public CamundaClientAuthProperties getAuth() {
        return this.auth;
    }

    public void setAuth(CamundaClientAuthProperties auth) {
        this.auth = auth;
    }

    @Deprecated(forRemoval=true, since="8.8")
    @DeprecatedConfigurationProperty(replacement="camunda.client")
    public ZeebeClientProperties getZeebe() {
        return this.zeebe;
    }

    @Deprecated
    public void setZeebe(ZeebeClientProperties zeebe) {
        this.zeebe = zeebe;
    }

    @Deprecated(forRemoval=true, since="8.8")
    @DeprecatedConfigurationProperty
    public IdentityProperties getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityProperties identity) {
        this.identity = identity;
    }

    @Deprecated(forRemoval=true, since="8.8")
    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.tenant-ids")
    public List<String> getTenantIds() {
        return this.tenantIds;
    }

    @Deprecated(forRemoval=true, since="8.8")
    public void setTenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Deprecated(forRemoval=true, since="8.8")
    @DeprecatedConfigurationProperty(replacement="camunda.client.cloud.cluster-id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Deprecated(forRemoval=true)
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Deprecated(forRemoval=true, since="8.8")
    @DeprecatedConfigurationProperty(replacement="camunda.client.cloud.region")
    public String getRegion() {
        return this.region;
    }

    @Deprecated(forRemoval=true, since="8.8")
    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return "CamundaClientProperties{enabled=" + this.enabled + ", mode=" + String.valueOf((Object)this.mode) + ", cloud=" + String.valueOf(this.cloud) + ", auth=" + String.valueOf(this.auth) + ", identity=" + String.valueOf(this.identity) + ", executionThreads=" + this.executionThreads + ", messageTimeToLive=" + String.valueOf(this.messageTimeToLive) + ", maxMessageSize=" + String.valueOf(this.maxMessageSize) + ", maxMetadataSize=" + String.valueOf(this.maxMetadataSize) + ", caCertificatePath='" + this.caCertificatePath + "', keepAlive=" + String.valueOf(this.keepAlive) + ", overrideAuthority='" + this.overrideAuthority + "', worker=" + String.valueOf(this.worker) + ", preferRestOverGrpc=" + this.preferRestOverGrpc + ", grpcAddress=" + String.valueOf(this.grpcAddress) + ", restAddress=" + String.valueOf(this.restAddress) + ", deployment=" + String.valueOf(this.deployment) + ", tenantId='" + this.tenantId + "', requestTimeout=" + String.valueOf(this.requestTimeout) + "}";
    }

    public static enum ClientMode {
        selfManaged,
        saas;

    }
}

