/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import io.camunda.spring.client.properties.CamundaClientAuthProperties;
import io.camunda.spring.client.properties.CamundaClientLegacyPropertiesMapping;
import io.camunda.spring.client.properties.CamundaClientLegacyPropertiesMappingsLoader;
import io.camunda.spring.client.properties.CamundaClientProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CamundaClientPropertiesPostProcessor
implements EnvironmentPostProcessor {
    public static final String CAMUNDA_CLIENT_AUTH_METHOD = "camunda.client.auth.method";
    public static final String CAMUNDA_CLIENT_MODE = "camunda.client.mode";
    private static final String OVERRIDE_PREFIX = "camunda.client.worker.override.";
    private static final List<String> LEGACY_OVERRIDE_PREFIX = List.of("camunda.client.zeebe.override.", "zeebe.client.worker.override.");
    private static final Map<CamundaClientAuthProperties.AuthMethod, Set<String>> IMPLICIT_AUTH_METHOD_INDICATORS = new HashMap<CamundaClientAuthProperties.AuthMethod, Set<String>>();
    private final DeferredLog log;

    public CamundaClientPropertiesPostProcessor(DeferredLogFactory deferredLogFactory) {
        this.log = (DeferredLog)deferredLogFactory.getLog(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.mapLegacyProperties(environment);
        this.mapLegacyOverrides(environment);
        this.processClientMode(environment);
        this.processAuthMethod(environment);
    }

    private void mapLegacyOverrides(ConfigurableEnvironment environment) {
        environment.getPropertySources().stream().filter(o -> EnumerablePropertySource.class.isAssignableFrom(o.getClass())).map(EnumerablePropertySource.class::cast).forEach(propertySource -> {
            for (String propertyName : propertySource.getPropertyNames()) {
                for (String prefix : LEGACY_OVERRIDE_PREFIX) {
                    String newPropertyName;
                    String normalizedPropertyName = propertyName.replaceAll("_", ".").toLowerCase();
                    if (!normalizedPropertyName.startsWith(prefix) || environment.containsProperty(newPropertyName = OVERRIDE_PREFIX + normalizedPropertyName.substring(prefix.length()))) continue;
                    this.log.debug((Object)String.format("Mapping worker override from '%s' to '%s'", propertyName, newPropertyName));
                    this.addMapPropertySourceFirst(propertyName, Map.of(newPropertyName, Objects.requireNonNull(propertySource.getProperty(propertyName))), environment);
                }
            }
        });
    }

    private void mapLegacyProperties(ConfigurableEnvironment environment) {
        List<CamundaClientLegacyPropertiesMapping> mappings = CamundaClientLegacyPropertiesMappingsLoader.load();
        mappings.forEach(mapping -> this.detectPropertyValue(environment, (CamundaClientLegacyPropertiesMapping)mapping).forEach((legacyPropertyName, detectedPropertyValue) -> this.addMapPropertySourceFirst((String)legacyPropertyName, Map.of(mapping.getPropertyName(), detectedPropertyValue), environment)));
    }

    private Map<String, String> detectPropertyValue(ConfigurableEnvironment environment, CamundaClientLegacyPropertiesMapping property) {
        if (environment.containsProperty(property.getPropertyName())) {
            this.log.debug((Object)String.format("Property '%s' found, not looking up legacy properties", property.getPropertyName()));
            return Map.of();
        }
        for (String legacyPropertyName : property.getLegacyPropertyNames()) {
            if (!environment.containsProperty(legacyPropertyName)) continue;
            this.log.warn((Object)String.format("Legacy property '%s' found, setting to '%s'. Please update your setup to use the latest property", legacyPropertyName, property.getPropertyName()));
            return Map.of(legacyPropertyName, Objects.requireNonNull(environment.getProperty(legacyPropertyName)));
        }
        this.log.debug((Object)String.format("No property found for '%s'", property.getPropertyName()));
        return Map.of();
    }

    private void processClientMode(ConfigurableEnvironment environment) {
        try {
            CamundaClientProperties.ClientMode clientMode = (CamundaClientProperties.ClientMode)((Object)environment.getProperty(CAMUNDA_CLIENT_MODE, CamundaClientProperties.ClientMode.class));
            if (clientMode == null) {
                if (this.isImplicitSaas(environment)) {
                    clientMode = CamundaClientProperties.ClientMode.saas;
                } else {
                    return;
                }
            }
            String propertiesFile = this.determinePropertiesFile(clientMode);
            this.addYamlPropertySourceLast(propertiesFile, environment);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while post processing camunda properties", e);
        }
    }

    private void processAuthMethod(ConfigurableEnvironment environment) {
        try {
            CamundaClientProperties.ClientMode clientMode = (CamundaClientProperties.ClientMode)((Object)environment.getProperty(CAMUNDA_CLIENT_MODE, CamundaClientProperties.ClientMode.class));
            CamundaClientAuthProperties.AuthMethod authMethod = (CamundaClientAuthProperties.AuthMethod)((Object)environment.getProperty(CAMUNDA_CLIENT_AUTH_METHOD, CamundaClientAuthProperties.AuthMethod.class));
            if (clientMode == CamundaClientProperties.ClientMode.saas) {
                if (authMethod != CamundaClientAuthProperties.AuthMethod.oidc) {
                    this.log.warn((Object)String.format("'%s' is '%s', but '%s' is manually set to '%s', will be ignored and the application will fall back to use '%s'", new Object[]{CAMUNDA_CLIENT_MODE, clientMode, CAMUNDA_CLIENT_AUTH_METHOD, authMethod, CamundaClientAuthProperties.AuthMethod.oidc}));
                    this.addMapPropertySourceFirst(CAMUNDA_CLIENT_MODE, Map.of(CAMUNDA_CLIENT_AUTH_METHOD, CamundaClientAuthProperties.AuthMethod.oidc), environment);
                }
                return;
            }
            if (authMethod == null) {
                Map<CamundaClientAuthProperties.AuthMethod, Set<String>> implicitAuthMethods = this.detectImplicitAuthMethods(environment);
                if (implicitAuthMethods.size() > 1) {
                    throw new IllegalStateException(CamundaClientPropertiesPostProcessor.formatImplicitAuthModeIndicator(implicitAuthMethods));
                }
                if (implicitAuthMethods.size() == 1) {
                    authMethod = (CamundaClientAuthProperties.AuthMethod)((Object)implicitAuthMethods.keySet().stream().findFirst().get());
                    this.log.info((Object)String.format("Implicit '%s'='%s' detected due to '%s' being set.", new Object[]{CAMUNDA_CLIENT_AUTH_METHOD, authMethod, ((Map.Entry)implicitAuthMethods.entrySet().stream().findFirst().get()).getValue()}));
                }
            }
            if (authMethod == null) {
                this.log.warn((Object)String.format("No '%s' detected, will be set to '%s'", new Object[]{CAMUNDA_CLIENT_AUTH_METHOD, CamundaClientAuthProperties.AuthMethod.none}));
                authMethod = CamundaClientAuthProperties.AuthMethod.none;
            }
            String propertiesFile = this.determinePropertiesFile(authMethod);
            this.addYamlPropertySourceLast(propertiesFile, environment);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while post processing camunda properties", e);
        }
    }

    static String formatImplicitAuthModeIndicator(Map<CamundaClientAuthProperties.AuthMethod, Set<String>> implicitAuthMethods) {
        return String.format("Mutually exclusive implicit auth method indicators detected (%s)", implicitAuthMethods.entrySet().stream().map(e -> "'" + ((CamundaClientAuthProperties.AuthMethod)((Object)((Object)e.getKey()))).name() + "' -> '" + String.join((CharSequence)"', '", (Iterable)e.getValue()) + "'").collect(Collectors.joining(",")));
    }

    private void addMapPropertySourceFirst(String sourceName, Map<String, Object> properties, ConfigurableEnvironment environment) {
        MapPropertySource propertySource = new MapPropertySource(sourceName, properties);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private void addYamlPropertySourceLast(String propertiesFile, ConfigurableEnvironment environment) throws IOException {
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        ClassPathResource resource = new ClassPathResource(propertiesFile);
        List props = loader.load(propertiesFile, (Resource)resource);
        for (PropertySource prop : props) {
            environment.getPropertySources().addLast(prop);
        }
    }

    private Map<CamundaClientAuthProperties.AuthMethod, Set<String>> detectImplicitAuthMethods(ConfigurableEnvironment environment) {
        return IMPLICIT_AUTH_METHOD_INDICATORS.entrySet().stream().map(e -> Map.entry((CamundaClientAuthProperties.AuthMethod)((Object)((Object)e.getKey())), ((Set)e.getValue()).stream().filter(arg_0 -> ((ConfigurableEnvironment)environment).containsProperty(arg_0)).collect(Collectors.toSet()))).filter(e -> !((Set)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isImplicitSaas(ConfigurableEnvironment environment) {
        if (environment.containsProperty("camunda.client.cloud.cluster-id")) {
            this.log.info((Object)String.format("Implicit '%s' '%s' detected, will be used", new Object[]{CAMUNDA_CLIENT_MODE, CamundaClientProperties.ClientMode.saas}));
            return true;
        }
        return false;
    }

    private String determinePropertiesFile(CamundaClientAuthProperties.AuthMethod authMethod) {
        return switch (authMethod) {
            default -> throw new IncompatibleClassChangeError();
            case CamundaClientAuthProperties.AuthMethod.basic -> "auth-methods/basic.yaml";
            case CamundaClientAuthProperties.AuthMethod.oidc -> "auth-methods/oidc.yaml";
            case CamundaClientAuthProperties.AuthMethod.none -> "auth-methods/none.yaml";
        };
    }

    private String determinePropertiesFile(CamundaClientProperties.ClientMode clientMode) {
        return switch (clientMode) {
            default -> throw new IncompatibleClassChangeError();
            case CamundaClientProperties.ClientMode.selfManaged -> "modes/self-managed.yaml";
            case CamundaClientProperties.ClientMode.saas -> "modes/saas.yaml";
        };
    }

    static {
        IMPLICIT_AUTH_METHOD_INDICATORS.put(CamundaClientAuthProperties.AuthMethod.basic, Set.of("camunda.client.auth.username", "camunda.client.auth.password"));
        IMPLICIT_AUTH_METHOD_INDICATORS.put(CamundaClientAuthProperties.AuthMethod.oidc, Set.of("camunda.client.auth.client-id", "camunda.client.auth.client-secret"));
    }
}

