/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.properties;

import io.camunda.client.impl.CamundaClientBuilderImpl;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="zeebe.client")
@Deprecated(since="8.6", forRemoval=true)
public class ZeebeClientConfigurationProperties {
    public static final CamundaClientBuilderImpl DEFAULT = (CamundaClientBuilderImpl)new CamundaClientBuilderImpl().withProperties(new Properties());
    public static final String CONNECTION_MODE_CLOUD = "CLOUD";
    public static final String CONNECTION_MODE_ADDRESS = "ADDRESS";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeClientConfigurationProperties.class);
    private final Environment environment;
    private String connectionMode;
    private String defaultTenantId = DEFAULT.getDefaultTenantId();
    private List<String> defaultJobWorkerTenantIds;
    private boolean applyEnvironmentVariableOverrides = false;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private Broker broker = new Broker();
    @NestedConfigurationProperty
    private Cloud cloud = new Cloud();
    @NestedConfigurationProperty
    private Worker worker = new Worker();
    @NestedConfigurationProperty
    private Message message = new Message();
    @NestedConfigurationProperty
    private Security security = new Security();
    @NestedConfigurationProperty
    private Job job = new Job();
    private boolean ownsJobWorkerExecutor;
    private boolean defaultJobWorkerStreamEnabled = DEFAULT.getDefaultJobWorkerStreamEnabled();
    private Duration requestTimeout = DEFAULT.getDefaultRequestTimeout();

    @Autowired
    public ZeebeClientConfigurationProperties(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    @DeprecatedConfigurationProperty(replacement="no overrides are applied anymore")
    public void applyOverrides() {
        if (this.isApplyEnvironmentVariableOverrides()) {
            if (io.camunda.client.impl.util.Environment.system().isDefined("ZEEBE_INSECURE_CONNECTION")) {
                this.security.plaintext = io.camunda.client.impl.util.Environment.system().getBoolean("ZEEBE_INSECURE_CONNECTION");
            }
            if (io.camunda.client.impl.util.Environment.system().isDefined("ZEEBE_CA_CERTIFICATE_PATH")) {
                this.security.certPath = io.camunda.client.impl.util.Environment.system().get("ZEEBE_CA_CERTIFICATE_PATH");
            }
            if (io.camunda.client.impl.util.Environment.system().isDefined("ZEEBE_KEEP_ALIVE")) {
                this.broker.keepAlive = Duration.ofMillis(Long.parseUnsignedLong(io.camunda.client.impl.util.Environment.system().get("ZEEBE_KEEP_ALIVE")));
            }
            if (io.camunda.client.impl.util.Environment.system().isDefined("ZEEBE_OVERRIDE_AUTHORITY")) {
                this.security.overrideAuthority = io.camunda.client.impl.util.Environment.system().get("ZEEBE_OVERRIDE_AUTHORITY");
            }
        }
        if (this.environment != null) {
            if (this.broker.gatewayAddress == null && this.environment.containsProperty("zeebe.client.gateway.address")) {
                this.broker.gatewayAddress = this.environment.getProperty("zeebe.client.gateway.address");
            }
            if (this.cloud.clientSecret == null && this.environment.containsProperty("zeebe.client.cloud.secret")) {
                this.cloud.clientSecret = this.environment.getProperty("zeebe.client.cloud.secret");
            }
            if (this.worker.defaultName == null && this.environment.containsProperty("zeebe.client.worker.name")) {
                this.worker.defaultName = this.environment.getProperty("zeebe.client.worker.name");
            }
            if ((this.defaultTenantId == null || this.defaultTenantId.equals(DEFAULT.getDefaultTenantId())) && this.environment.containsProperty("zeebe.client.tenantId")) {
                this.defaultTenantId = this.environment.getProperty("zeebe.client.tenantId");
            }
        }
        if (this.defaultJobWorkerTenantIds == null && this.defaultTenantId != null) {
            this.defaultJobWorkerTenantIds = Collections.singletonList(this.defaultTenantId);
        }
    }

    @DeprecatedConfigurationProperty(replacement="nested property is deprecated")
    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    @DeprecatedConfigurationProperty(replacement="nested property is deprecated")
    public Cloud getCloud() {
        return this.cloud;
    }

    public void setCloud(Cloud cloud) {
        this.cloud = cloud;
    }

    @DeprecatedConfigurationProperty(replacement="nested property is deprecated")
    public Worker getWorker() {
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    @DeprecatedConfigurationProperty(replacement="nested property is deprecated")
    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @DeprecatedConfigurationProperty(replacement="nested property is deprecated")
    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    @DeprecatedConfigurationProperty(replacement="nested property is deprecated")
    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.request-timeout")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @DeprecatedConfigurationProperty(replacement="not required")
    public boolean isApplyEnvironmentVariableOverrides() {
        return this.applyEnvironmentVariableOverrides;
    }

    public void setApplyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.applyEnvironmentVariableOverrides = applyEnvironmentVariableOverrides;
    }

    public void setOwnsJobWorkerExecutor(boolean ownsJobWorkerExecutor) {
        this.ownsJobWorkerExecutor = ownsJobWorkerExecutor;
    }

    @DeprecatedConfigurationProperty(replacement="always true, unless custom zeebe client executor service is registered")
    public boolean ownsJobWorkerExecutor() {
        return this.ownsJobWorkerExecutor;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address")
    public String getGatewayAddress() {
        if (this.connectionMode != null && !this.connectionMode.isEmpty()) {
            LOGGER.info("Using connection mode '{}' to connect to Zeebe", (Object)this.connectionMode);
            if (CONNECTION_MODE_CLOUD.equalsIgnoreCase(this.connectionMode)) {
                return this.cloud.getGatewayAddress();
            }
            if (CONNECTION_MODE_ADDRESS.equalsIgnoreCase(this.connectionMode)) {
                return this.broker.getGatewayAddress();
            }
            throw new RuntimeException(this.createInvalidConnectionModeErrorMessage());
        }
        if (this.cloud.isConfigured()) {
            return this.cloud.getGatewayAddress();
        }
        return this.broker.getGatewayAddress();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address")
    public URI getGrpcAddress() {
        if (this.connectionMode != null && !this.connectionMode.isEmpty()) {
            LOGGER.info("Using connection mode '{}' to connect to Zeebe GRPC", (Object)this.connectionMode);
            if (CONNECTION_MODE_CLOUD.equalsIgnoreCase(this.connectionMode)) {
                return this.cloud.getGrpcAddress();
            }
            if (CONNECTION_MODE_ADDRESS.equalsIgnoreCase(this.connectionMode)) {
                return this.broker.getGrpcAddress();
            }
            throw new RuntimeException(this.createInvalidConnectionModeErrorMessage());
        }
        if (this.cloud.isConfigured()) {
            return this.cloud.getGrpcAddress();
        }
        return this.broker.getGrpcAddress();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.rest-address")
    public URI getRestAddress() {
        if (this.connectionMode != null && !this.connectionMode.isEmpty()) {
            LOGGER.info("Using connection mode '{}' to connect to Zeebe REST", (Object)this.connectionMode);
            if (CONNECTION_MODE_CLOUD.equalsIgnoreCase(this.connectionMode)) {
                return this.cloud.getRestAddress();
            }
            if (CONNECTION_MODE_ADDRESS.equalsIgnoreCase(this.connectionMode)) {
                return this.broker.getRestAddress();
            }
            throw new RuntimeException(this.createInvalidConnectionModeErrorMessage());
        }
        if (this.cloud.isConfigured()) {
            return this.cloud.getRestAddress();
        }
        return this.broker.getRestAddress();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.tenant-ids", reason="the first provided tenant id is applied")
    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    public void setDefaultTenantId(String defaultTenantId) {
        this.defaultTenantId = defaultTenantId;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.tenant-ids")
    public List<String> getDefaultJobWorkerTenantIds() {
        return this.defaultJobWorkerTenantIds;
    }

    public void setDefaultJobWorkerTenantIds(List<String> defaultJobWorkerTenantIds) {
        this.defaultJobWorkerTenantIds = defaultJobWorkerTenantIds;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.stream-enabled")
    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.defaultJobWorkerStreamEnabled;
    }

    public void setDefaultJobWorkerStreamEnabled(boolean defaultJobWorkerStreamEnabled) {
        this.defaultJobWorkerStreamEnabled = defaultJobWorkerStreamEnabled;
    }

    @DeprecatedConfigurationProperty(replacement="not required")
    public boolean useDefaultRetryPolicy() {
        return false;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.mode", reason="There are client modes now")
    public String getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(String connectionMode) {
        this.connectionMode = connectionMode;
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.request-timeout")
    public Duration getDefaultRequestTimeout() {
        return this.getRequestTimeout();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.execution-threads")
    public int getNumJobWorkerExecutionThreads() {
        return this.worker.getThreads();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.max-jobs-active")
    public int getDefaultJobWorkerMaxJobsActive() {
        return this.worker.getMaxJobsActive();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.name")
    public String getDefaultJobWorkerName() {
        return this.worker.getDefaultName();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.type")
    public String getDefaultJobWorkerType() {
        return this.worker.getDefaultType();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.timeout")
    public Duration getDefaultJobTimeout() {
        return this.job.getTimeout();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.poll-interval")
    public Duration getDefaultJobPollInterval() {
        return this.job.getPollInterval();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.message-time-to-live")
    public Duration getDefaultMessageTimeToLive() {
        return this.message.getTimeToLive();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address", reason="plaintext is determined by the url protocol (http/https) now")
    public Boolean isPlaintextConnectionEnabled() {
        return this.security.isPlaintext();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.ca-certificate-path")
    public String getCaCertificatePath() {
        return this.security.getCertPath();
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="camunda.client.override-authority")
    public String getOverrideAuthority() {
        return this.security.getOverrideAuthority();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.keep-alive")
    public Duration getKeepAlive() {
        return this.broker.getKeepAlive();
    }

    @DeprecatedConfigurationProperty(replacement="camunda.client.max-message-size")
    public int getMaxMessageSize() {
        return this.message.getMaxMessageSize();
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.cloud, this.worker, this.message, this.security, this.job, this.requestTimeout);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeebeClientConfigurationProperties that = (ZeebeClientConfigurationProperties)o;
        return Objects.equals(this.broker, that.broker) && Objects.equals(this.cloud, that.cloud) && Objects.equals(this.worker, that.worker) && Objects.equals(this.message, that.message) && Objects.equals(this.security, that.security) && Objects.equals(this.job, that.job) && Objects.equals(this.requestTimeout, that.requestTimeout);
    }

    public String toString() {
        return "ZeebeClientConfigurationProperties{environment=" + String.valueOf(this.environment) + ", connectionMode='" + this.connectionMode + "', defaultTenantId='" + this.defaultTenantId + "', defaultJobWorkerTenantIds=" + String.valueOf(this.defaultJobWorkerTenantIds) + ", applyEnvironmentVariableOverrides=" + this.applyEnvironmentVariableOverrides + ", enabled=" + this.enabled + ", broker=" + String.valueOf(this.broker) + ", cloud=" + String.valueOf(this.cloud) + ", worker=" + String.valueOf(this.worker) + ", message=" + String.valueOf(this.message) + ", security=" + String.valueOf(this.security) + ", job=" + String.valueOf(this.job) + ", ownsJobWorkerExecutor=" + this.ownsJobWorkerExecutor + ", defaultJobWorkerStreamEnabled=" + this.defaultJobWorkerStreamEnabled + ", requestTimeout=" + String.valueOf(this.requestTimeout) + "}";
    }

    private String createInvalidConnectionModeErrorMessage() {
        return "Value '" + this.connectionMode + "' for ConnectionMode is invalid, valid values are CLOUD or ADDRESS";
    }

    public static class Broker {
        private String gatewayAddress;
        private URI grpcAddress;
        private URI restAddress;
        private Duration keepAlive = DEFAULT.getKeepAlive();

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address")
        public String getGatewayAddress() {
            return this.gatewayAddress;
        }

        public void setGatewayAddress(String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address")
        public URI getGrpcAddress() {
            return this.grpcAddress;
        }

        public void setGrpcAddress(URI grpcAddress) {
            if (grpcAddress != null && grpcAddress.getHost() == null) {
                throw new IllegalArgumentException("grpcAddress must be an absolute URI");
            }
            this.grpcAddress = grpcAddress;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.rest-address")
        public URI getRestAddress() {
            return this.restAddress;
        }

        public void setRestAddress(URI restAddress) {
            if (restAddress != null && restAddress.getHost() == null) {
                throw new IllegalArgumentException("restAddress must be an absolute URI");
            }
            this.restAddress = restAddress;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.keep-alive")
        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public int hashCode() {
            return Objects.hash(this.gatewayAddress, this.grpcAddress, this.restAddress, this.keepAlive);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Broker broker = (Broker)o;
            return Objects.equals(this.gatewayAddress, broker.gatewayAddress) && Objects.equals(this.grpcAddress, broker.grpcAddress) && Objects.equals(this.restAddress, broker.restAddress) && Objects.equals(this.keepAlive, broker.keepAlive);
        }

        public String toString() {
            return "Broker{gatewayAddress='" + this.gatewayAddress + ", grpcAddress=" + String.valueOf(this.grpcAddress) + ", restAddress=" + String.valueOf(this.restAddress) + ", keepAlive=" + String.valueOf(this.keepAlive) + "}";
        }
    }

    public static class Cloud {
        private String clusterId;
        private String clientId;
        private String clientSecret;
        private String region = "bru-2";
        private String scope;
        private String baseUrl = "zeebe.camunda.io";
        private String authUrl = "https://login.cloud.camunda.io/oauth/token";
        private int port = 443;
        private String credentialsCachePath;

        @DeprecatedConfigurationProperty(replacement="camunda.client.cluster-id")
        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.auth.client-id")
        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.auth.client-secret")
        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.region")
        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.scope")
        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address", reason="The zeebe client url is now configured as http/https url")
        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.auth.issuer")
        public String getAuthUrl() {
            return this.authUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address", reason="The zeebe client url is now configured as http/https url")
        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.auth.credentials-cache-path")
        public String getCredentialsCachePath() {
            return this.credentialsCachePath;
        }

        public void setCredentialsCachePath(String credentialsCachePath) {
            this.credentialsCachePath = credentialsCachePath;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.auth.audience")
        public String getAudience() {
            return String.format("%s.%s.%s", this.clusterId, this.region, this.baseUrl);
        }

        @DeprecatedConfigurationProperty(replacement="not required", reason="This is determined by 'camunda.client.mode'")
        public boolean isConfigured() {
            return this.clusterId != null;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address", reason="The zeebe client url is now configured as http/https url")
        public String getGatewayAddress() {
            return String.format("%s.%s.%s:%d", this.clusterId, this.region, this.baseUrl, this.port);
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address")
        public URI getGrpcAddress() {
            return URI.create(String.format("https://%s.%s.%s:%d", this.clusterId, this.region, this.baseUrl, this.port));
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.rest-address")
        public URI getRestAddress() {
            return URI.create(String.format("https://%s.%s:%d/%s", this.region, this.baseUrl, this.port, this.clusterId));
        }

        public int hashCode() {
            return Objects.hash(this.clusterId, this.clientId, this.clientSecret, this.region, this.scope, this.baseUrl, this.authUrl, this.port, this.credentialsCachePath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cloud cloud = (Cloud)o;
            return this.port == cloud.port && Objects.equals(this.clusterId, cloud.clusterId) && Objects.equals(this.clientId, cloud.clientId) && Objects.equals(this.clientSecret, cloud.clientSecret) && Objects.equals(this.region, cloud.region) && Objects.equals(this.scope, cloud.scope) && Objects.equals(this.baseUrl, cloud.baseUrl) && Objects.equals(this.authUrl, cloud.authUrl) && Objects.equals(this.credentialsCachePath, cloud.credentialsCachePath);
        }

        public String toString() {
            return "Cloud{clusterId='" + this.clusterId + "', clientId='***', clientSecret='***', region='" + this.region + "', scope='" + this.scope + "', baseUrl='" + this.baseUrl + "', authUrl='" + this.authUrl + "', port=" + this.port + ", credentialsCachePath='" + this.credentialsCachePath + "'}";
        }
    }

    public static class Worker {
        private Integer maxJobsActive = DEFAULT.getDefaultJobWorkerMaxJobsActive();
        private Integer threads = DEFAULT.getNumJobWorkerExecutionThreads();
        private String defaultName = null;
        private String defaultType = null;
        private Map<String, JobWorkerValue> override = new HashMap<String, JobWorkerValue>();

        @DeprecatedConfigurationProperty(replacement="camunda.client.override")
        public Map<String, JobWorkerValue> getOverride() {
            return this.override;
        }

        public void setOverride(Map<String, JobWorkerValue> override) {
            this.override = override;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.max-jobs-active")
        public Integer getMaxJobsActive() {
            return this.maxJobsActive;
        }

        public void setMaxJobsActive(Integer maxJobsActive) {
            this.maxJobsActive = maxJobsActive;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.execution-threads")
        public Integer getThreads() {
            return this.threads;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.name")
        public String getDefaultName() {
            return this.defaultName;
        }

        public void setDefaultName(String defaultName) {
            this.defaultName = defaultName;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.type")
        public String getDefaultType() {
            return this.defaultType;
        }

        public void setDefaultType(String defaultType) {
            this.defaultType = defaultType;
        }

        public int hashCode() {
            return Objects.hash(this.maxJobsActive, this.threads, this.defaultName, this.defaultType, this.override);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Worker worker = (Worker)o;
            return Objects.equals(this.maxJobsActive, worker.maxJobsActive) && Objects.equals(this.threads, worker.threads) && Objects.equals(this.defaultName, worker.defaultName) && Objects.equals(this.defaultType, worker.defaultType) && Objects.equals(this.override, worker.override);
        }

        public String toString() {
            return "Worker{maxJobsActive=" + this.maxJobsActive + ", threads=" + this.threads + ", defaultName='" + this.defaultName + "', defaultType='" + this.defaultType + "', override=" + String.valueOf(this.override) + "}";
        }
    }

    public static class Message {
        private Duration timeToLive = DEFAULT.getDefaultMessageTimeToLive();
        private int maxMessageSize = DEFAULT.getMaxMessageSize();

        @DeprecatedConfigurationProperty(replacement="camunda.client.message-time-to-live")
        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.max-message-size")
        public int getMaxMessageSize() {
            return this.maxMessageSize;
        }

        public void setMaxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        public int hashCode() {
            return Objects.hash(this.timeToLive);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message = (Message)o;
            return Objects.equals(this.timeToLive, message.timeToLive);
        }

        public String toString() {
            return "Message{timeToLive=" + String.valueOf(this.timeToLive) + ", maxMessageSize=" + this.maxMessageSize + "}";
        }
    }

    public static class Security {
        private Boolean plaintext;
        private String overrideAuthority = DEFAULT.getOverrideAuthority();
        private String certPath = DEFAULT.getCaCertificatePath();

        @DeprecatedConfigurationProperty(replacement="camunda.client.grpc-address", reason="plaintext is determined by the url protocol (http/https) now")
        public Boolean isPlaintext() {
            return this.plaintext;
        }

        public void setPlaintext(Boolean plaintext) {
            this.plaintext = plaintext;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.ca-certificate-path")
        public String getCertPath() {
            return this.certPath;
        }

        public void setCertPath(String certPath) {
            this.certPath = certPath;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.override-authority")
        public String getOverrideAuthority() {
            return this.overrideAuthority;
        }

        public void setOverrideAuthority(String overrideAuthority) {
            this.overrideAuthority = overrideAuthority;
        }

        public int hashCode() {
            return Objects.hash(this.plaintext, this.overrideAuthority, this.certPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Security security = (Security)o;
            return this.plaintext == security.plaintext && Objects.equals(this.overrideAuthority, security.overrideAuthority) && Objects.equals(this.certPath, security.certPath);
        }

        public String toString() {
            return "Security{plaintext=" + this.plaintext + ", overrideAuthority='" + this.overrideAuthority + "', certPath='" + this.certPath + "'}";
        }
    }

    public static class Job {
        private Duration timeout = DEFAULT.getDefaultJobTimeout();
        private Duration pollInterval = DEFAULT.getDefaultJobPollInterval();

        @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.timeout")
        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @DeprecatedConfigurationProperty(replacement="camunda.client.worker.defaults.poll-interval")
        public Duration getPollInterval() {
            return this.pollInterval;
        }

        public void setPollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
        }

        public int hashCode() {
            return Objects.hash(this.timeout, this.pollInterval);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Job job = (Job)o;
            return Objects.equals(this.timeout, job.timeout) && Objects.equals(this.pollInterval, job.pollInterval);
        }

        public String toString() {
            return "Job{timeout=" + String.valueOf(this.timeout) + ", pollInterval=" + String.valueOf(this.pollInterval) + "}";
        }
    }
}

