/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.spring.client.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.spring.client.testsupport.CamundaSpringProcessTestContext;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;
import io.camunda.zeebe.client.impl.util.ExecutorResource;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.spring.client.configuration.ZeebeClientConfigurationImpl;
import io.camunda.zeebe.spring.client.event.ZeebeLifecycleEventProducer;
import io.grpc.ManagedChannel;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Deprecated(since="8.6", forRemoval=true)
@Configuration
@ConditionalOnCamundaClientEnabled
@ConditionalOnMissingBean(value={CamundaSpringProcessTestContext.class})
@ConditionalOnBean(value={CamundaClientConfiguration.class})
public class ZeebeClientProdAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeClientProdAutoConfiguration.class);

    @Bean
    public ZeebeClientConfiguration zeebeClientConfiguration(CamundaClientConfiguration camundaClientConfiguration) {
        return new ZeebeClientConfigurationImpl(camundaClientConfiguration);
    }

    @Bean(destroyMethod="close")
    public ZeebeClient zeebeClient(ZeebeClientConfiguration configuration) {
        LOG.info("Creating zeebeClient using zeebeClientConfiguration [{}]", (Object)configuration);
        ScheduledExecutorService jobWorkerExecutor = configuration.jobWorkerExecutor();
        if (jobWorkerExecutor != null) {
            ManagedChannel managedChannel = ZeebeClientImpl.buildChannel((ZeebeClientConfiguration)configuration);
            GatewayGrpc.GatewayStub gatewayStub = ZeebeClientImpl.buildGatewayStub((ManagedChannel)managedChannel, (ZeebeClientConfiguration)configuration);
            ExecutorResource executorResource = new ExecutorResource(jobWorkerExecutor, configuration.ownsJobWorkerExecutor());
            return new ZeebeClientImpl(configuration, managedChannel, gatewayStub, executorResource);
        }
        return new ZeebeClientImpl(configuration);
    }

    @Bean
    public ZeebeLifecycleEventProducer zeebeLifecycleEventProducer(ZeebeClient client, ApplicationEventPublisher publisher) {
        return new ZeebeLifecycleEventProducer(client, publisher);
    }
}

