/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.client.jobhandling;

import io.camunda.client.api.command.CompleteJobCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.CompleteJobResponse;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.client.impl.Loggers;
import io.camunda.spring.client.annotation.value.JobWorkerValue;
import io.camunda.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.CommandWrapper;
import io.camunda.spring.client.jobhandling.JobExceptionHandlingStrategy;
import io.camunda.spring.client.jobhandling.JobHandlingUtil;
import io.camunda.spring.client.jobhandling.parameter.ParameterResolver;
import io.camunda.spring.client.jobhandling.result.ResultProcessor;
import io.camunda.spring.client.jobhandling.result.ResultProcessorContext;
import io.camunda.spring.client.metrics.MetricsRecorder;
import java.util.List;
import org.slf4j.Logger;

public class JobHandlerInvokingSpringBeans
implements JobHandler {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private final JobWorkerValue workerValue;
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private final List<ParameterResolver> parameterResolvers;
    private final ResultProcessor resultProcessor;
    private final JobExceptionHandlingStrategy jobExceptionHandlingStrategy;

    public JobHandlerInvokingSpringBeans(JobWorkerValue workerValue, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, List<ParameterResolver> parameterResolvers, ResultProcessor resultProcessor, JobExceptionHandlingStrategy jobExceptionHandlingStrategy) {
        this.workerValue = workerValue;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
        this.parameterResolvers = parameterResolvers;
        this.resultProcessor = resultProcessor;
        this.jobExceptionHandlingStrategy = jobExceptionHandlingStrategy;
    }

    public void handle(JobClient jobClient, ActivatedJob job) throws Exception {
        List<Object> args = this.createParameters(jobClient, job);
        LOG.trace("Handle {} and invoke worker {}", (Object)job, (Object)this.workerValue);
        this.metricsRecorder.increase("camunda.job.invocations", "activated", job.getType());
        try {
            Object methodInvocationResult = this.workerValue.getMethodInfo().invoke(args.toArray());
            Object result = this.resultProcessor.process(new ResultProcessorContext(methodInvocationResult, job));
            if (this.workerValue.getAutoComplete().booleanValue()) {
                LOG.trace("Auto completing {}", (Object)job);
                CommandWrapper command = this.createCommandWrapper(this.createCompleteCommand(jobClient, job, result), job);
                command.executeAsyncWithMetrics("camunda.job.invocations", "completed", job.getType());
            } else if (result != null) {
                LOG.warn("Result provided but auto complete disabled for job {}", (Object)job);
            }
        }
        catch (Exception e) {
            this.jobExceptionHandlingStrategy.handleException(e, new JobExceptionHandlingStrategy.ExceptionHandlingContext(jobClient, job, this.workerValue));
        }
    }

    private CommandWrapper createCommandWrapper(FinalCommandStep<?> command, ActivatedJob job) {
        return new CommandWrapper(command, job, this.commandExceptionHandlingStrategy, this.metricsRecorder, this.workerValue.getMaxRetries());
    }

    private List<Object> createParameters(JobClient jobClient, ActivatedJob job) {
        return this.parameterResolvers.stream().map(resolver -> resolver.resolve(jobClient, job)).toList();
    }

    private FinalCommandStep<CompleteJobResponse> createCompleteCommand(JobClient jobClient, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        return (FinalCommandStep)JobHandlingUtil.applyVariables(result, completeCommand);
    }
}

