/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.CamundaTaskListClient;
import io.camunda.tasklist.CamundaTaskListClientProperties;
import io.camunda.tasklist.auth.Authentication;
import io.camunda.tasklist.auth.JwtAuthentication;
import io.camunda.tasklist.auth.JwtCredential;
import io.camunda.tasklist.auth.SimpleAuthentication;
import io.camunda.tasklist.auth.SimpleCredential;
import io.camunda.tasklist.auth.TokenResponseMapper;
import io.camunda.tasklist.spring.ObjectMapperConfiguration;
import io.camunda.tasklist.spring.TasklistClientConfigurationProperties;
import io.camunda.zeebe.client.ZeebeClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(value={TasklistClientConfigurationProperties.class})
@ConditionalOnProperty(value={"tasklist.client.enabled"}, matchIfMissing=true)
@Import(value={ObjectMapperConfiguration.class})
public class TasklistClientConfiguration {
    private final TasklistClientConfigurationProperties properties;
    private final ObjectMapper objectMapper;

    @Autowired
    public TasklistClientConfiguration(TasklistClientConfigurationProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public CamundaTaskListClient camundaTasklistClient(CamundaTaskListClientProperties properties, @Autowired(required=false) ZeebeClient zeebeClient) {
        return new CamundaTaskListClient(properties, zeebeClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public CamundaTaskListClientProperties taskListClientProperties(Authentication authentication) {
        return new CamundaTaskListClientProperties(authentication, this.properties.baseUrl().toString(), this.properties.defaults().returnVariables(), this.properties.defaults().loadTruncatedVariables(), this.properties.defaults().useZeebeUserTasks());
    }

    @Bean
    @ConditionalOnMissingBean
    public Authentication tasklistAuthentication() {
        if (this.properties.profile() == null) {
            throw new IllegalStateException("'tasklist.client.profile' is required");
        }
        switch (this.properties.profile()) {
            case simple: {
                return new SimpleAuthentication(new SimpleCredential(this.properties.username(), this.properties.password(), this.properties.baseUrl(), this.properties.sessionTimeout()));
            }
            case oidc: 
            case saas: {
                return new JwtAuthentication(new JwtCredential(this.properties.clientId(), this.properties.clientSecret(), this.properties.audience(), this.properties.authUrl(), this.properties.scope()), (TokenResponseMapper)new TokenResponseMapper.JacksonTokenResponseMapper(this.objectMapper));
            }
        }
        throw new IllegalStateException("Unsupported profile: " + String.valueOf((Object)this.properties.profile()));
    }
}

