/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.configs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.runtime.util.inbound.InboundJobHandlerContext;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LocalContextBeanConfiguration {
    @Bean
    public ObjectMapper jacksonMapper() {
        return new ObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    protected SecretProvider getSecretProvider() {
        Iterator<SecretProvider> secretProviders = ServiceLoader.load(SecretProvider.class).iterator();
        if (!secretProviders.hasNext()) {
            return System::getenv;
        }
        return secretProviders.next();
    }

    @Bean
    public InboundConnectorContext jobHandlerContext(SecretProvider secretProvider) {
        return new InboundJobHandlerContext(secretProvider);
    }
}

