/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.importer;

import io.camunda.connector.runtime.inbound.registry.InboundConnectorProperties;
import io.camunda.connector.runtime.inbound.registry.InboundConnectorRegistry;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.dto.ProcessDefinition;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.search.SearchQuery;
import io.camunda.operate.search.Sort;
import io.camunda.operate.search.SortOrder;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"camunda.connector.polling.enabled"})
public class ProcessDefinitionImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionImporter.class);
    private InboundConnectorRegistry registry;
    private CamundaOperateClient camundaOperateClient;

    @Autowired
    public ProcessDefinitionImporter(InboundConnectorRegistry registry, CamundaOperateClient camundaOperateClient) {
        this.registry = registry;
        this.camundaOperateClient = camundaOperateClient;
    }

    @Scheduled(fixedDelayString="${camunda.connector.polling.interval:5000}")
    public void scheduleImport() throws OperateException {
        LOG.trace("Query process deployments...");
        SearchQuery processDefinitionQuery = new SearchQuery.Builder().withSort(new Sort("version", SortOrder.ASC)).build();
        List processDefinitions = this.camundaOperateClient.searchProcessDefinitions(processDefinitionQuery);
        LOG.trace("... returned " + processDefinitions.size() + " process definitions.");
        for (ProcessDefinition processDefinition : processDefinitions) {
            if (this.registry.processDefinitionChecked(processDefinition.getKey())) continue;
            LOG.debug("Check " + processDefinition + " for connectors.");
            this.registry.markProcessDefinitionChecked(processDefinition.getKey(), processDefinition.getBpmnProcessId(), processDefinition.getVersion().intValue());
            String processDefinitionXml = this.camundaOperateClient.getProcessDefinitionXml(processDefinition.getKey());
            this.processBpmnXml(processDefinition, processDefinitionXml);
        }
        this.registry.rewireWebhookEndpoints();
    }

    private void processBpmnXml(ProcessDefinition processDefinition, String resource) {
        BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(resource.getBytes()));
        bpmnModelInstance.getDefinitions().getChildElementsByType(Process.class).stream().flatMap(process -> process.getChildElementsByType(StartEvent.class).stream()).map(startEvent -> (ZeebeProperties)startEvent.getSingleExtensionElement(ZeebeProperties.class)).filter(Objects::nonNull).forEach(zeebeProperties -> this.processZeebeProperties(processDefinition, (ZeebeProperties)zeebeProperties));
    }

    private void processZeebeProperties(ProcessDefinition processDefinition, ZeebeProperties zeebeProperties) {
        InboundConnectorProperties properties = new InboundConnectorProperties(processDefinition.getBpmnProcessId(), processDefinition.getVersion().intValue(), processDefinition.getKey(), zeebeProperties.getProperties().stream().collect(HashMap::new, (m, zeebeProperty) -> m.put(zeebeProperty.getName(), zeebeProperty.getValue()), HashMap::putAll));
        if (InboundConnectorProperties.TYPE_WEBHOOK.equals(properties.getType())) {
            LOG.debug("Found inbound webhook connector: " + properties);
            this.registry.registerWebhookConnector(properties);
        } else {
            LOG.warn("Found other connector than webhook, which is not yet supported: " + properties);
        }
    }
}

