/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.operate;

import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.auth.AuthInterface;
import io.camunda.operate.auth.SaasAuthentication;
import io.camunda.operate.auth.SelfManagedAuthentication;
import io.camunda.operate.auth.SimpleAuthentication;
import io.camunda.operate.exception.OperateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OperateClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OperateClientFactory.class);
    @Value(value="${zeebe.client.cloud.cluster-id:#{null}}")
    private String clusterId;
    @Value(value="${zeebe.client.cloud.region:bru-2}")
    private String region;
    @Value(value="${zeebe.client.cloud.client-id:#{null}}")
    private String clientId;
    @Value(value="${zeebe.client.cloud.client-secret:#{null}}")
    private String clientSecret;
    @Value(value="${camunda.operate.client.client-id:#{null}}")
    private String operateClientId;
    @Value(value="${camunda.operate.client.client-secret:#{null}}")
    private String operateClientSecret;
    @Value(value="${camunda.operate.client.url:#{null}}")
    private String operateUrl;
    @Value(value="${camunda.operate.client.username:#{null}}")
    private String operateUsername;
    @Value(value="${camunda.operate.client.password:#{null}}")
    private String operatePassword;
    @Value(value="${camunda.operate.client.keycloak-url:#{null}}")
    private String operateKeycloakUrl;
    @Value(value="${camunda.operate.client.keycloak-realm:#{null}}")
    private String operateKeycloakRealm;

    private String getOperateUrl() {
        if (this.clusterId != null) {
            String url = "https://" + this.region + ".operate.camunda.io/" + this.clusterId + "/";
            LOG.debug("Connecting to Camunda Operate SaaS via URL: " + url);
            return url;
        }
        if (this.operateUrl != null) {
            LOG.debug("Connecting to Camunda Operate on URL: " + this.operateUrl);
            return this.operateUrl;
        }
        throw new IllegalArgumentException("In order to connect to Camunda Operate you need to specify either a SaaS clusterId or an Operate URL.");
    }

    public AuthInterface getAuthentication(String operateUrl) {
        if (this.operateKeycloakUrl != null) {
            if (this.operateClientId != null) {
                LOG.debug("Authenticating with Camunda Operate using Keycloak on " + this.operateKeycloakUrl);
                return new SelfManagedAuthentication(this.operateClientId, this.operateClientSecret).keycloakUrl(this.operateKeycloakUrl).keycloakRealm(this.operateKeycloakRealm);
            }
            if (this.clientId != null) {
                LOG.debug("Authenticating with Camunda Operate using Keycloak on " + this.operateKeycloakUrl);
                return new SelfManagedAuthentication(this.clientId, this.clientSecret).keycloakUrl(this.operateKeycloakUrl).keycloakRealm(this.operateKeycloakRealm);
            }
        } else {
            if (this.operateClientId != null) {
                LOG.debug("Authenticating with Camunda Operate using client id and secret");
                return new SaasAuthentication(this.operateClientId, this.operateClientSecret);
            }
            if (this.clientId != null) {
                LOG.debug("Authenticating with Camunda Operate using client id and secret");
                return new SaasAuthentication(this.clientId, this.clientSecret);
            }
            if (this.operateUsername != null) {
                LOG.debug("Authenticating with Camunda Operate using username and password");
                return new SimpleAuthentication("demo", "demo", operateUrl);
            }
        }
        throw new IllegalArgumentException("In order to connect to Camunda Operate you need to configure authentication properly.");
    }

    public CamundaOperateClient camundaOperateClient() throws OperateException {
        String operateUrl = this.getOperateUrl();
        return new CamundaOperateClient.Builder().operateUrl(operateUrl).authentication(this.getAuthentication(operateUrl)).build();
    }
}

