/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.operate;

import io.camunda.connector.runtime.inbound.operate.OperateClientFactory;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.dto.FlownodeInstance;
import io.camunda.operate.dto.Incident;
import io.camunda.operate.dto.ProcessDefinition;
import io.camunda.operate.dto.ProcessInstance;
import io.camunda.operate.dto.Variable;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.search.SearchQuery;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class OperateClientLifecycle
extends CamundaOperateClient
implements SmartLifecycle,
Supplier<CamundaOperateClient> {
    public static final int PHASE = 22222;
    protected boolean autoStartup = false;
    protected boolean running = false;
    protected boolean runningInTestContext = false;
    protected final OperateClientFactory factory;
    protected CamundaOperateClient delegate;

    @Autowired
    public OperateClientLifecycle(OperateClientFactory factory) {
        this.factory = factory;
    }

    public OperateClientLifecycle(CamundaOperateClient delegate) {
        this.factory = null;
        this.delegate = delegate;
    }

    public void start() {
        if (this.factory != null) {
            try {
                this.delegate = this.factory.camundaOperateClient();
            }
            catch (OperateException e) {
                throw new RuntimeException("Could not start Camunda Operate Client: " + e.getMessage(), e);
            }
            this.running = true;
        } else {
            this.runningInTestContext = true;
        }
    }

    public void stop() {
        try {
            this.delegate = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.running = false;
        }
    }

    @Override
    public CamundaOperateClient get() {
        if (!this.isRunning()) {
            this.start();
        }
        return this.delegate;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 22222;
    }

    public ProcessDefinition getProcessDefinition(Long key) throws OperateException {
        return this.get().getProcessDefinition(key);
    }

    public List<ProcessDefinition> searchProcessDefinitions(SearchQuery query) throws OperateException {
        return this.get().searchProcessDefinitions(query);
    }

    public String getProcessDefinitionXml(Long key) throws OperateException {
        return this.get().getProcessDefinitionXml(key);
    }

    public BpmnModelInstance getProcessDefinitionModel(Long key) throws OperateException {
        return this.get().getProcessDefinitionModel(key);
    }

    public ProcessInstance getProcessInstance(Long key) throws OperateException {
        return this.get().getProcessInstance(key);
    }

    public List<ProcessInstance> searchProcessInstances(SearchQuery query) throws OperateException {
        return this.get().searchProcessInstances(query);
    }

    public FlownodeInstance getFlownodeInstance(Long key) throws OperateException {
        return this.get().getFlownodeInstance(key);
    }

    public List<FlownodeInstance> searchFlownodeInstances(SearchQuery query) throws OperateException {
        return this.get().searchFlownodeInstances(query);
    }

    public Incident getIncident(Long key) throws OperateException {
        return this.get().getIncident(key);
    }

    public List<Incident> searchIncidents(SearchQuery query) throws OperateException {
        return this.get().searchIncidents(query);
    }

    public Variable getVariable(Long key) throws OperateException {
        return this.get().getVariable(key);
    }

    public List<Variable> searchVariables(SearchQuery query) throws OperateException {
        return this.get().searchVariables(query);
    }

    public String getOperateUrl() {
        return this.get().getOperateUrl();
    }

    public void setOperateUrl(String operateUrl) {
        this.get().setOperateUrl(operateUrl);
    }

    public Header getAuthHeader() {
        return this.get().getAuthHeader();
    }

    public void setAuthHeader(Header authHeader) {
        this.get().setAuthHeader(authHeader);
    }

    public void setTokenExpiration(int tokenExpiration) {
        this.get().setTokenExpiration(tokenExpiration);
    }
}

