/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.registry;

import java.util.Map;

public class InboundConnectorProperties {
    public static String TYPE_WEBHOOK = "webhook";
    public static String TYPE_SUBSCRIPTION = "subscription";
    private final String type;
    private final Map<String, String> properties;
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final int version;

    public InboundConnectorProperties(String bpmnProcessId, int version, long processDefinitionKey, Map<String, String> properties) {
        this.type = properties.get("inbound.type");
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.properties = properties;
        this.processDefinitionKey = processDefinitionKey;
    }

    public String getConnectorIdentifier() {
        return this.type + "-" + this.bpmnProcessId + "-" + this.version;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "ConnectorProperties{type='" + this.type + '\'' + ", processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", properties=" + this.properties + '}';
    }
}

