/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.registry;

import io.camunda.connector.runtime.inbound.registry.InboundConnectorProperties;
import io.camunda.connector.runtime.inbound.registry.WebhookConnectorPropertyComparator;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.stereotype.Service;

@Service
public class InboundConnectorRegistry {
    private Set<Long> registeredProcessDefinitionKeys = new HashSet<Long>();
    private Map<String, List<WebhookConnectorProperties>> registeredWebhookConnectorsByContextPath = new HashMap<String, List<WebhookConnectorProperties>>();
    private Map<String, Set<WebhookConnectorProperties>> sortedWebhookConnectorsByBpmnId = new HashMap<String, Set<WebhookConnectorProperties>>();
    private Map<String, TreeSet<Integer>> processDefinitionVersionsByBpmnId = new HashMap<String, TreeSet<Integer>>();
    private boolean webhookRegistrationDirty = true;

    public void reset() {
        this.registeredProcessDefinitionKeys = new HashSet<Long>();
        this.registeredWebhookConnectorsByContextPath = new HashMap<String, List<WebhookConnectorProperties>>();
    }

    public boolean processDefinitionChecked(long processDefinitionKey) {
        return this.registeredProcessDefinitionKeys.contains(processDefinitionKey);
    }

    public void markProcessDefinitionChecked(long processDefinitionKey, String bpmnProcessId, Integer version) {
        this.registeredProcessDefinitionKeys.add(processDefinitionKey);
        if (!this.processDefinitionVersionsByBpmnId.containsKey(bpmnProcessId)) {
            this.processDefinitionVersionsByBpmnId.put(bpmnProcessId, new TreeSet());
        }
        this.processDefinitionVersionsByBpmnId.get(bpmnProcessId).add(version);
        this.webhookRegistrationDirty = true;
    }

    private boolean hasLatestVersion(String bpmnProcessId) {
        return this.processDefinitionVersionsByBpmnId.containsKey(bpmnProcessId);
    }

    private Integer getLatestVersion(String bpmnProcessId) {
        return this.processDefinitionVersionsByBpmnId.get(bpmnProcessId).last();
    }

    public void registerWebhookConnector(InboundConnectorProperties properties) {
        WebhookConnectorProperties webhookConnectorProperties = new WebhookConnectorProperties(properties);
        String bpmnId = webhookConnectorProperties.getBpmnProcessId();
        if (!this.sortedWebhookConnectorsByBpmnId.containsKey(bpmnId)) {
            this.sortedWebhookConnectorsByBpmnId.put(bpmnId, new TreeSet<WebhookConnectorProperties>(new WebhookConnectorPropertyComparator()));
        }
        this.sortedWebhookConnectorsByBpmnId.get(bpmnId).add(webhookConnectorProperties);
        this.webhookRegistrationDirty = true;
    }

    public void rewireWebhookEndpoints() {
        HashMap<String, List<WebhookConnectorProperties>> newWebhooks = new HashMap<String, List<WebhookConnectorProperties>>();
        for (String bpmnId : this.sortedWebhookConnectorsByBpmnId.keySet()) {
            Set<WebhookConnectorProperties> connectorsForBpmnId = this.sortedWebhookConnectorsByBpmnId.get(bpmnId);
            WebhookConnectorProperties lastConnector = null;
            HashMap<String, WebhookConnectorProperties> candidatesByContext = new HashMap<String, WebhookConnectorProperties>();
            for (WebhookConnectorProperties props : connectorsForBpmnId) {
                candidatesByContext.put(props.getContext(), props);
                lastConnector = props;
            }
            if (this.hasLatestVersion(bpmnId) && this.getLatestVersion(bpmnId) > lastConnector.getVersion()) {
                candidatesByContext.remove(lastConnector.getContext());
            }
            for (WebhookConnectorProperties props : candidatesByContext.values()) {
                InboundConnectorRegistry.putWebhookEndpoint(newWebhooks, props);
            }
        }
        this.webhookRegistrationDirty = false;
        this.registeredWebhookConnectorsByContextPath = newWebhooks;
    }

    private static void putWebhookEndpoint(Map<String, List<WebhookConnectorProperties>> webhookMap, WebhookConnectorProperties webhookConnectorProperties) {
        String context = webhookConnectorProperties.getContext();
        if (!webhookMap.containsKey(context)) {
            webhookMap.put(context, new ArrayList());
        }
        webhookMap.get(context).add(webhookConnectorProperties);
    }

    public boolean containsContextPath(String context) {
        return this.getRegisteredWebhookConnectorsByContextPath().containsKey(context);
    }

    public Collection<WebhookConnectorProperties> getWebhookConnectorByContextPath(String context) {
        return this.getRegisteredWebhookConnectorsByContextPath().get(context);
    }

    private Map<String, List<WebhookConnectorProperties>> getRegisteredWebhookConnectorsByContextPath() {
        if (this.webhookRegistrationDirty) {
            this.rewireWebhookEndpoints();
        }
        return this.registeredWebhookConnectorsByContextPath;
    }

    public void registerOtherInboundConnector(InboundConnectorProperties properties) {
    }
}

