/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.signature;

import io.camunda.connector.runtime.inbound.signature.HMACAlgoCustomerChoice;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMACSignatureValidator {
    private static final Logger LOG = LoggerFactory.getLogger(HMACSignatureValidator.class);
    private final byte[] requestBody;
    private final Map<String, String> headers;
    private final String hmacHeader;
    private final String hmacSecretKey;
    private final HMACAlgoCustomerChoice hmacAlgo;

    public HMACSignatureValidator(byte[] requestBody, Map<String, String> headers, String hmacHeader, String hmacSecretKey, HMACAlgoCustomerChoice hmacAlgo) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.hmacHeader = hmacHeader;
        this.hmacSecretKey = hmacSecretKey;
        this.hmacAlgo = hmacAlgo;
    }

    public boolean isRequestValid() throws NoSuchAlgorithmException, InvalidKeyException {
        String providedHmac = this.headers.get(this.hmacHeader.toLowerCase());
        LOG.debug("Given HMAC from webhook call: {}", (Object)providedHmac);
        if (providedHmac == null || providedHmac.length() == 0) {
            return false;
        }
        byte[] signedEntity = this.requestBody;
        Mac sha256_HMAC = Mac.getInstance(this.hmacAlgo.getAlgoReference());
        SecretKeySpec secret_key = new SecretKeySpec(this.hmacSecretKey.getBytes(StandardCharsets.UTF_8), this.hmacAlgo.getAlgoReference());
        sha256_HMAC.init(secret_key);
        byte[] expectedHmac = sha256_HMAC.doFinal(signedEntity);
        String expectedShortHmacString = Hex.encodeHexString((byte[])expectedHmac);
        String expectedLongHmacString = this.hmacAlgo.getTag() + "=" + expectedShortHmacString;
        LOG.debug("Computed HMAC from webhook body: {}, {}", (Object)expectedShortHmacString, (Object)expectedLongHmacString);
        return providedHmac.equals(expectedShortHmacString) || providedHmac.equals(expectedLongHmacString);
    }
}

