/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.runtime.inbound.registry.InboundConnectorProperties;
import io.camunda.connector.runtime.inbound.registry.InboundConnectorRegistry;
import io.camunda.connector.runtime.inbound.signature.HMACAlgoCustomerChoice;
import io.camunda.connector.runtime.inbound.signature.HMACSignatureValidator;
import io.camunda.connector.runtime.inbound.signature.HMACSwitchCustomerChoice;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorProperties;
import io.camunda.connector.runtime.inbound.webhook.WebhookResponse;
import io.camunda.connector.runtime.util.feel.FeelEngineWrapper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@ConditionalOnProperty(value={"camunda.connector.webhook.enabled"})
public class InboundWebhookRestController {
    private static final Logger LOG = LoggerFactory.getLogger(InboundWebhookRestController.class);
    private final InboundConnectorRegistry registry;
    private final InboundConnectorContext connectorContext;
    private final ZeebeClient zeebeClient;
    private final FeelEngineWrapper feelEngine;
    private final ObjectMapper jsonMapper;
    private final MetricsRecorder metricsRecorder;

    @Autowired
    public InboundWebhookRestController(InboundConnectorRegistry registry, InboundConnectorContext connectorContext, ZeebeClient zeebeClient, FeelEngineWrapper feelEngine, ObjectMapper jsonMapper, MetricsRecorder metricsRecorder) {
        this.registry = registry;
        this.connectorContext = connectorContext;
        this.zeebeClient = zeebeClient;
        this.feelEngine = feelEngine;
        this.jsonMapper = jsonMapper;
        this.metricsRecorder = metricsRecorder;
    }

    @PostMapping(value={"/inbound/{context}"})
    public ResponseEntity<WebhookResponse> inbound(@PathVariable String context, @RequestBody byte[] bodyAsByteArray, @RequestHeader Map<String, String> headers) throws IOException {
        LOG.debug("Received inbound hook on {}", (Object)context);
        if (!this.registry.containsContextPath(context)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No webhook found for context: " + context);
        }
        this.metricsRecorder.increase("camunda.connector.inbound.invocations", "activated", InboundConnectorProperties.TYPE_WEBHOOK);
        Map bodyAsMap = (Map)this.jsonMapper.readValue(bodyAsByteArray, Map.class);
        HashMap<String, Map<String, String>> request = new HashMap<String, Map<String, String>>();
        request.put("body", bodyAsMap);
        request.put("headers", headers);
        Map<String, Object> webhookContext = Collections.singletonMap("request", request);
        WebhookResponse response = new WebhookResponse();
        Collection<WebhookConnectorProperties> connectors = this.registry.getWebhookConnectorByContextPath(context);
        for (WebhookConnectorProperties connectorProperties : connectors) {
            this.connectorContext.replaceSecrets((Object)connectorProperties);
            try {
                if (!this.isValidHmac(connectorProperties, bodyAsByteArray, headers)) {
                    LOG.debug("HMAC validation failed {} :: {}", (Object)context, webhookContext);
                    response.addUnauthorizedConnector(connectorProperties);
                    continue;
                }
                if (!this.activationConditionTriggered(connectorProperties, webhookContext)) {
                    LOG.debug("Should not activate {} :: {}", (Object)context, webhookContext);
                    response.addUnactivatedConnector(connectorProperties);
                    continue;
                }
                ProcessInstanceEvent processInstanceEvent = this.executeWebhookConnector(connectorProperties, webhookContext);
                LOG.debug("Webhook {} created process instance {}", (Object)connectorProperties, (Object)processInstanceEvent);
                response.addExecutedConnector(connectorProperties, processInstanceEvent);
            }
            catch (Exception exception) {
                LOG.error("Webhook {} failed to create process instance", (Object)connectorProperties, (Object)exception);
                this.metricsRecorder.increase("camunda.connector.inbound.invocations", "failed", InboundConnectorProperties.TYPE_WEBHOOK);
                response.addException(connectorProperties, exception);
            }
        }
        this.metricsRecorder.increase("camunda.connector.inbound.invocations", "completed", InboundConnectorProperties.TYPE_WEBHOOK);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)response);
    }

    private boolean isValidHmac(WebhookConnectorProperties connectorProperties, byte[] bodyAsByteArray, Map<String, String> headers) throws NoSuchAlgorithmException, InvalidKeyException {
        if (HMACSwitchCustomerChoice.disabled.name().equals(connectorProperties.getShouldValidateHmac())) {
            return true;
        }
        HMACSignatureValidator validator = new HMACSignatureValidator(bodyAsByteArray, headers, connectorProperties.getHmacHeader(), connectorProperties.getHmacSecret(), HMACAlgoCustomerChoice.valueOf(connectorProperties.getHmacAlgorithm()));
        return validator.isRequestValid();
    }

    private ProcessInstanceEvent executeWebhookConnector(WebhookConnectorProperties connectorProperties, Map<String, Object> webhookContext) {
        Map<String, Object> variables = this.extractVariables(connectorProperties, webhookContext);
        return (ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(connectorProperties.getBpmnProcessId()).version(connectorProperties.getVersion()).variables(variables).send().join();
    }

    private Map<String, Object> extractVariables(WebhookConnectorProperties connectorProperties, Map<String, Object> context) {
        String variableMapping = connectorProperties.getVariableMapping();
        if (variableMapping == null) {
            return context;
        }
        return (Map)this.feelEngine.evaluate(variableMapping, context);
    }

    private boolean activationConditionTriggered(WebhookConnectorProperties connectorProperties, Map<String, Object> context) {
        String activationCondition = connectorProperties.getActivationCondition();
        if (activationCondition == null || activationCondition.trim().length() == 0) {
            return true;
        }
        Object shouldActivate = this.feelEngine.evaluate(activationCondition, context);
        return Boolean.TRUE.equals(shouldActivate);
    }
}

