/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook;

import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.runtime.inbound.registry.InboundConnectorProperties;
import io.camunda.connector.runtime.inbound.signature.HMACSwitchCustomerChoice;

public class WebhookConnectorProperties {
    private final InboundConnectorProperties genericProperties;
    @Secret
    private String context;
    private String activationCondition;
    private String variableMapping;
    private String shouldValidateHmac;
    @Secret
    private String hmacSecret;
    @Secret
    private String hmacHeader;
    private String hmacAlgorithm;

    public WebhookConnectorProperties(InboundConnectorProperties properties) {
        this.genericProperties = properties;
        this.context = this.readPropertyRequired("inbound.context");
        this.activationCondition = this.readPropertyNullable("inbound.activationCondition");
        this.variableMapping = this.readPropertyNullable("inbound.variableMapping");
        this.shouldValidateHmac = this.readPropertyWithDefault("inbound.shouldValidateHmac", HMACSwitchCustomerChoice.disabled.name());
        this.hmacSecret = this.readPropertyNullable("inbound.hmacSecret");
        this.hmacHeader = this.readPropertyNullable("inbound.hmacHeader");
        this.hmacAlgorithm = this.readPropertyNullable("inbound.hmacAlgorithm");
    }

    public String getConnectorIdentifier() {
        return "" + this.genericProperties.getType() + "-" + this.getContext() + "-" + this.genericProperties.getBpmnProcessId() + "-" + this.genericProperties.getVersion();
    }

    protected String readPropertyWithDefault(String propertyName, String defaultValue) {
        return this.genericProperties.getProperties().getOrDefault(propertyName, defaultValue);
    }

    protected String readPropertyNullable(String propertyName) {
        return this.genericProperties.getProperties().get(propertyName);
    }

    protected String readPropertyRequired(String propertyName) {
        String result = this.readPropertyNullable(propertyName);
        if (result == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' must be set for connector");
        }
        return result;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(String activationCondition) {
        this.activationCondition = activationCondition;
    }

    public String getVariableMapping() {
        return this.variableMapping;
    }

    public void setVariableMapping(String variableMapping) {
        this.variableMapping = variableMapping;
    }

    public String getShouldValidateHmac() {
        return this.shouldValidateHmac;
    }

    public void setShouldValidateHmac(String shouldValidateHmac) {
        this.shouldValidateHmac = shouldValidateHmac;
    }

    public String getHmacSecret() {
        return this.hmacSecret;
    }

    public void setHmacSecret(String hmacSecret) {
        this.hmacSecret = hmacSecret;
    }

    public String getHmacHeader() {
        return this.hmacHeader;
    }

    public void setHmacHeader(String hmacHeader) {
        this.hmacHeader = hmacHeader;
    }

    public String getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    public void setHmacAlgorithm(String hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
    }

    public String getBpmnProcessId() {
        return this.genericProperties.getBpmnProcessId();
    }

    public int getVersion() {
        return this.genericProperties.getVersion();
    }

    public String getType() {
        return this.genericProperties.getType();
    }

    public long getProcessDefinitionKey() {
        return this.genericProperties.getProcessDefinitionKey();
    }

    public String toString() {
        return "WebhookConnectorProperties-" + this.genericProperties.toString();
    }
}

