/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook;

import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorProperties;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebhookResponse {
    private List<String> unauthorizedConnectors = new ArrayList<String>();
    private List<String> unactivatedConnectors = new ArrayList<String>();
    private Map<String, ProcessInstanceEvent> executedConnectors = new HashMap<String, ProcessInstanceEvent>();
    private List<String> errors = new ArrayList<String>();

    public void addUnauthorizedConnector(WebhookConnectorProperties connectorProperties) {
        this.unauthorizedConnectors.add(connectorProperties.getConnectorIdentifier());
    }

    public void addUnactivatedConnector(WebhookConnectorProperties connectorProperties) {
        this.unactivatedConnectors.add(connectorProperties.getConnectorIdentifier());
    }

    public void addExecutedConnector(WebhookConnectorProperties connectorProperties, ProcessInstanceEvent processInstanceEvent) {
        this.executedConnectors.put(connectorProperties.getConnectorIdentifier(), processInstanceEvent);
    }

    public void addException(WebhookConnectorProperties connectorProperties, Exception exception) {
        this.errors.add(connectorProperties.getConnectorIdentifier() + ">" + exception.getMessage());
    }

    public List<String> getUnauthorizedConnectors() {
        return this.unauthorizedConnectors;
    }

    public List<String> getUnactivatedConnectors() {
        return this.unactivatedConnectors;
    }

    public Map<String, ProcessInstanceEvent> getExecutedConnectors() {
        return this.executedConnectors;
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

