/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.example;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.annotation.JobWorker;
import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ExampleJobWorkers {
    private static Logger log = LoggerFactory.getLogger(ExampleJobWorkers.class);

    @JobWorker(type="foo")
    public void handleFooJob(ActivatedJob job) {
        ExampleJobWorkers.logJob((ActivatedJob)job, null);
    }

    @JobWorker
    public Map<String, Object> bar(ActivatedJob job, @Variable String a) {
        ExampleJobWorkers.logJob((ActivatedJob)job, (Object)a);
        return Collections.singletonMap("someResult", "42");
    }

    @JobWorker(type="fail", fetchAllVariables=true)
    public void handleFailingJob(JobClient client, ActivatedJob job, @Variable String someResult) {
        ExampleJobWorkers.logJob((ActivatedJob)job, (Object)someResult);
        throw new ZeebeBpmnError("DOESNT_WORK", "This will actually never work :-)");
    }

    private static void logJob(ActivatedJob job, Object parameterValue) {
        log.info("complete job\n>>> [type: {}, key: {}, element: {}, workflow instance: {}]\n{deadline; {}]\n[headers: {}]\n[variable parameter: {}\n[variables: {}]", new Object[]{job.getType(), job.getKey(), job.getElementId(), job.getProcessInstanceKey(), Instant.ofEpochMilli(job.getDeadline()), job.getCustomHeaders(), parameterValue, job.getVariables()});
    }
}

