/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.example;

import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.spring.client.lifecycle.ZeebeClientLifecycle;
import io.camunda.zeebe.spring.example.ExampleApplication;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PeriodicProcessStarter {
    private static Logger log = LoggerFactory.getLogger(ExampleApplication.class);
    @Autowired
    private ZeebeClientLifecycle client;

    @Scheduled(fixedRate=5000L)
    public void startProcesses() {
        if (!this.client.isRunning()) {
            return;
        }
        ProcessInstanceEvent event = (ProcessInstanceEvent)this.client.newCreateInstanceCommand().bpmnProcessId("demoProcess").latestVersion().variables("{\"a\": \"" + UUID.randomUUID().toString() + "\",\"b\": \"" + new Date().toString() + "\"}").send().join();
        log.info("started instance for workflowKey='{}', bpmnProcessId='{}', version='{}' with workflowInstanceKey='{}'", new Object[]{event.getProcessDefinitionKey(), event.getBpmnProcessId(), event.getVersion(), event.getProcessInstanceKey()});
    }
}

