/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.properties.ZeebeClientProperties;
import io.grpc.ClientInterceptor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Lazy;

@ConfigurationProperties(prefix="zeebe.client")
public class ZeebeClientConfigurationProperties
implements ZeebeClientProperties {
    public static final ZeebeClientBuilderImpl DEFAULT = (ZeebeClientBuilderImpl)new ZeebeClientBuilderImpl().withProperties(new Properties());
    @NestedConfigurationProperty
    private Broker broker = new Broker();
    @NestedConfigurationProperty
    private Cloud cloud = new Cloud();
    @NestedConfigurationProperty
    private Worker worker = new Worker();
    @NestedConfigurationProperty
    private Message message = new Message();
    @NestedConfigurationProperty
    private Security security = new Security();
    @NestedConfigurationProperty
    private Job job = new Job();
    @Lazy
    @Autowired
    private JsonMapper jsonMapper;
    private ArrayList<ClientInterceptor> interceptors = new ArrayList();
    private Duration requestTimeout = DEFAULT.getDefaultRequestTimeout();

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public Cloud getCloud() {
        return this.cloud;
    }

    public void setCloud(Cloud cloud) {
        this.cloud = cloud;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setInterceptors(ArrayList<ClientInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeebeClientConfigurationProperties that = (ZeebeClientConfigurationProperties)o;
        return Objects.equals(this.broker, that.broker) && Objects.equals(this.cloud, that.cloud) && Objects.equals(this.worker, that.worker) && Objects.equals(this.message, that.message) && Objects.equals(this.security, that.security) && Objects.equals(this.job, that.job) && Objects.equals(this.interceptors, that.interceptors) && Objects.equals(this.requestTimeout, that.requestTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.cloud, this.worker, this.message, this.security, this.job, this.interceptors, this.requestTimeout);
    }

    public String toString() {
        return "ZeebeClientConfigurationProperties{broker=" + this.broker + ", cloud=" + this.cloud + ", worker=" + this.worker + ", message=" + this.message + ", security=" + this.security + ", job=" + this.job + ", interceptors=" + this.interceptors + ", requestTimeout=" + this.requestTimeout + '}';
    }

    public String getGatewayAddress() {
        if (this.cloud.isConfigured()) {
            return this.cloud.getGatewayAddress();
        }
        return this.broker.getGatewayAddress();
    }

    public Duration getDefaultRequestTimeout() {
        return this.getRequestTimeout();
    }

    public int getNumJobWorkerExecutionThreads() {
        return this.worker.getThreads();
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return this.worker.getMaxJobsActive();
    }

    public String getDefaultJobWorkerName() {
        return this.worker.getDefaultName();
    }

    public String getDefaultJobWorkerType() {
        return this.worker.getDefaultType();
    }

    public Duration getDefaultJobTimeout() {
        return this.job.getTimeout();
    }

    public Duration getDefaultJobPollInterval() {
        return this.job.getPollInterval();
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.message.getTimeToLive();
    }

    public boolean isPlaintextConnectionEnabled() {
        return this.security.isPlaintext();
    }

    public String getCaCertificatePath() {
        return this.security.getCertPath();
    }

    public String getOverrideAuthority() {
        return this.security.getOverrideAuthority();
    }

    public CredentialsProvider getCredentialsProvider() {
        if (this.cloud.clientId != null && this.cloud.clientSecret != null) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.cloud.clientId).clientSecret(this.cloud.clientSecret).audience(this.cloud.getAudience()).authorizationServerUrl(this.cloud.authUrl).credentialsCachePath(this.cloud.credentialsCachePath).build();
        }
        return null;
    }

    public Duration getKeepAlive() {
        return this.broker.getKeepAlive();
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public static class Broker {
        private String gatewayAddress;
        private Duration keepAlive = DEFAULT.getKeepAlive();

        @Deprecated
        public String getContactPoint() {
            return this.getGatewayAddress();
        }

        @Deprecated
        public void setContactPoint(String contactPoint) {
            this.setGatewayAddress(contactPoint);
        }

        public String getGatewayAddress() {
            if (this.gatewayAddress != null) {
                return this.gatewayAddress;
            }
            return DEFAULT.getGatewayAddress();
        }

        public void setGatewayAddress(String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Broker broker = (Broker)o;
            return Objects.equals(this.gatewayAddress, broker.gatewayAddress) && Objects.equals(this.keepAlive, broker.keepAlive);
        }

        public int hashCode() {
            return Objects.hash(this.gatewayAddress, this.keepAlive);
        }

        public String toString() {
            return "Broker{gatewayAddress='" + this.gatewayAddress + '\'' + ", keepAlive=" + this.keepAlive + '}';
        }
    }

    public static class Cloud {
        private String clusterId;
        private String clientId;
        private String clientSecret;
        private String region = "bru-2";
        private String baseUrl = "zeebe.camunda.io";
        private String authUrl = "https://login.cloud.camunda.io/oauth/token";
        private int port = 443;
        private String credentialsCachePath;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getAuthUrl() {
            return this.authUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getCredentialsCachePath() {
            return this.credentialsCachePath;
        }

        public void setCredentialsCachePath(String credentialsCachePath) {
            this.credentialsCachePath = credentialsCachePath;
        }

        public String getAudience() {
            return String.format("%s.%s.%s", this.clusterId, this.region, this.baseUrl);
        }

        public boolean isConfigured() {
            return this.clusterId != null;
        }

        public String getGatewayAddress() {
            return String.format("%s.%s.%s:%d", this.clusterId, this.region, this.baseUrl, this.port);
        }
    }

    public static class Worker {
        private Integer maxJobsActive = DEFAULT.getDefaultJobWorkerMaxJobsActive();
        private Integer threads = DEFAULT.getNumJobWorkerExecutionThreads();
        private String defaultName = null;
        private String defaultType = null;
        private Map<String, ZeebeWorkerValue> override = new HashMap<String, ZeebeWorkerValue>();

        public Map<String, ZeebeWorkerValue> getOverride() {
            return this.override;
        }

        public void setOverride(Map<String, ZeebeWorkerValue> override) {
            this.override = override;
        }

        public Integer getMaxJobsActive() {
            return this.maxJobsActive;
        }

        public void setMaxJobsActive(Integer maxJobsActive) {
            this.maxJobsActive = maxJobsActive;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public void setDefaultName(String defaultName) {
            this.defaultName = defaultName;
        }

        public String getDefaultType() {
            return this.defaultType;
        }

        public void setDefaultType(String defaultType) {
            this.defaultType = defaultType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Worker worker = (Worker)o;
            return Objects.equals(this.maxJobsActive, worker.maxJobsActive) && Objects.equals(this.threads, worker.threads) && Objects.equals(this.defaultName, worker.defaultName) && Objects.equals(this.defaultType, worker.defaultType) && Objects.equals(this.override, worker.override);
        }

        public int hashCode() {
            return Objects.hash(this.maxJobsActive, this.threads, this.defaultName, this.defaultType, this.override);
        }

        public String toString() {
            return "Worker{maxJobsActive=" + this.maxJobsActive + ", threads=" + this.threads + ", defaultName='" + this.defaultName + '\'' + ", defaultType='" + this.defaultType + '\'' + ", override=" + this.override + '}';
        }
    }

    public static class Message {
        private Duration timeToLive = DEFAULT.getDefaultMessageTimeToLive();

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message = (Message)o;
            return Objects.equals(this.timeToLive, message.timeToLive);
        }

        public int hashCode() {
            return Objects.hash(this.timeToLive);
        }

        public String toString() {
            return "Message{timeToLive=" + this.timeToLive + '}';
        }
    }

    public static class Security {
        private boolean plaintext = DEFAULT.isPlaintextConnectionEnabled();
        private String overrideAuthority = DEFAULT.getOverrideAuthority();
        private String certPath = DEFAULT.getCaCertificatePath();

        public boolean isPlaintext() {
            return this.plaintext;
        }

        public void setPlaintext(boolean plaintext) {
            this.plaintext = plaintext;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public void setCertPath(String certPath) {
            this.certPath = certPath;
        }

        public String getOverrideAuthority() {
            return this.overrideAuthority;
        }

        public void setOverrideAuthority(String overrideAuthority) {
            this.overrideAuthority = overrideAuthority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Security security = (Security)o;
            return this.plaintext == security.plaintext && Objects.equals(this.overrideAuthority, security.overrideAuthority) && Objects.equals(this.certPath, security.certPath);
        }

        public int hashCode() {
            return Objects.hash(this.plaintext, this.overrideAuthority, this.certPath);
        }

        public String toString() {
            return "Security{plaintext=" + this.plaintext + ", overrideAuthority='" + this.overrideAuthority + '\'' + ", certPath='" + this.certPath + '\'' + '}';
        }
    }

    public static class Job {
        private Duration timeout = DEFAULT.getDefaultJobTimeout();
        private Duration pollInterval = DEFAULT.getDefaultJobPollInterval();

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public Duration getPollInterval() {
            return this.pollInterval;
        }

        public void setPollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Job job = (Job)o;
            return Objects.equals(this.timeout, job.timeout) && Objects.equals(this.pollInterval, job.pollInterval);
        }

        public int hashCode() {
            return Objects.hash(this.timeout, this.pollInterval);
        }

        public String toString() {
            return "Job{timeout=" + this.timeout + ", pollInterval=" + this.pollInterval + '}';
        }
    }
}

