/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.actuator;

import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricsRecorder
implements MetricsRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MeterRegistry meterRegistry;
    private final Map<String, Counter> counters = new HashMap<String, Counter>();

    public MicrometerMetricsRecorder(MeterRegistry meterRegistry) {
        LOGGER.info("Enabling Micrometer based metrics for spring-zeebe (available via Actuator)");
        this.meterRegistry = meterRegistry;
    }

    protected Counter newCounter(String metricName, String action, String jobType) {
        return this.meterRegistry.counter(metricName, new String[]{"action", action, "type", jobType});
    }

    public void increase(String metricName, String action, String jobType) {
        String key = metricName + "#" + action;
        if (!this.counters.containsKey(key)) {
            this.counters.put(key, this.newCounter(metricName, action, jobType));
        }
        this.counters.get(key).increment();
    }
}

