/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.config;

import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.spring.client.actuator.ZeebeActuatorConfiguration;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.properties.PropertyBasedZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.grpc.ClientInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Import(value={ZeebeActuatorConfiguration.class})
@EnableConfigurationProperties(value={ZeebeClientConfigurationProperties.class})
@Configuration
public class ZeebeClientStarterAutoConfiguration {
    private final ZeebeClientConfigurationProperties configurationProperties;

    public ZeebeClientStarterAutoConfiguration(ZeebeClientConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    @Bean
    @Primary
    public ZeebeClientBuilder builder(JsonMapper jsonMapper, @Autowired(required=false) List<ClientInterceptor> clientInterceptorList) {
        ZeebeClientBuilderImpl builder = new ZeebeClientBuilderImpl();
        builder.gatewayAddress(this.configurationProperties.getGatewayAddress());
        builder.defaultJobPollInterval(this.configurationProperties.getDefaultJobPollInterval());
        builder.defaultJobTimeout(this.configurationProperties.getDefaultJobTimeout());
        builder.defaultJobWorkerMaxJobsActive(this.configurationProperties.getDefaultJobWorkerMaxJobsActive());
        builder.defaultJobWorkerName(this.configurationProperties.getDefaultJobWorkerName());
        builder.defaultMessageTimeToLive(this.configurationProperties.getDefaultMessageTimeToLive());
        builder.numJobWorkerExecutionThreads(this.configurationProperties.getNumJobWorkerExecutionThreads());
        builder.defaultRequestTimeout(this.configurationProperties.getDefaultRequestTimeout());
        builder.credentialsProvider(this.configurationProperties.getCredentialsProvider());
        builder.caCertificatePath(this.configurationProperties.getCaCertificatePath());
        if (this.configurationProperties.isPlaintextConnectionEnabled()) {
            builder.usePlaintext();
        }
        builder.withJsonMapper(jsonMapper);
        List<ClientInterceptor> legacyInterceptors = this.configurationProperties.getInterceptors();
        if (!legacyInterceptors.isEmpty()) {
            builder.withInterceptors(legacyInterceptors.toArray(new ClientInterceptor[0]));
        } else if (clientInterceptorList != null && !clientInterceptorList.isEmpty()) {
            builder.withInterceptors(clientInterceptorList.toArray(new ClientInterceptor[0]));
        }
        return builder;
    }

    @Bean(value={"propertyBasedZeebeWorkerValueCustomizer"})
    @ConditionalOnMissingBean(name={"propertyBasedZeebeWorkerValueCustomizer"})
    public ZeebeWorkerValueCustomizer propertyBasedZeebeWorkerValueCustomizer() {
        return new PropertyBasedZeebeWorkerValueCustomizer(this.configurationProperties);
    }

    @Bean(name={"zeebeJsonMapper"})
    @ConditionalOnMissingBean
    public JsonMapper jsonMapper() {
        return new ZeebeObjectMapper();
    }
}

