/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.test;

import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.engine.EngineFactory;
import io.camunda.zeebe.spring.test.AbstractZeebeTestExecutionListener;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.SocketUtils;

public class ZeebeTestExecutionListener
extends AbstractZeebeTestExecutionListener
implements TestExecutionListener,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ZeebeTestEngine zeebeEngine;

    public void beforeTestMethod(@NonNull TestContext testContext) {
        int randomPort = SocketUtils.findAvailableTcpPort();
        LOGGER.info("Create Zeebe in-memory engine for test run on random port: " + randomPort + "...");
        this.zeebeEngine = EngineFactory.create((int)randomPort);
        this.zeebeEngine.start();
        this.setupWithZeebeEngine(testContext, this.zeebeEngine);
    }

    public void afterTestMethod(@NonNull TestContext testContext) {
        this.cleanup(testContext, this.zeebeEngine);
        this.zeebeEngine.stop();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

