/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.bean.value;

import io.camunda.zeebe.spring.client.bean.MethodInfo;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.bean.value.ZeebeAnnotationValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ZeebeWorkerValue
implements ZeebeAnnotationValue<MethodInfo> {
    private String type;
    private String name;
    private long timeout;
    private int maxJobsActive;
    private long requestTimeout;
    private long pollInterval;
    private boolean autoComplete;
    private String[] fetchVariables;
    private MethodInfo methodInfo;

    private ZeebeWorkerValue(String type, String name, long timeout, int maxJobsActive, long requestTimeout, long pollInterval, String[] fetchVariables, boolean forceFetchAllVariables, List<ParameterInfo> variableParameters, boolean autoComplete, MethodInfo methodInfo) {
        this.type = type;
        this.name = name;
        this.timeout = timeout;
        this.maxJobsActive = maxJobsActive;
        this.requestTimeout = requestTimeout;
        this.pollInterval = pollInterval;
        this.autoComplete = autoComplete;
        this.methodInfo = methodInfo;
        if (forceFetchAllVariables) {
            this.fetchVariables = new String[0];
        } else {
            HashSet<String> variables = new HashSet<String>();
            variables.addAll(Arrays.asList(fetchVariables));
            variables.addAll(variableParameters.stream().map(ParameterInfo::getParameterName).collect(Collectors.toList()));
            this.fetchVariables = variables.toArray(new String[0]);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getMaxJobsActive() {
        return this.maxJobsActive;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public String[] getFetchVariables() {
        return this.fetchVariables;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    @Override
    public MethodInfo getBeanInfo() {
        return this.getMethodInfo();
    }

    public static final ZeebeWorkerValueBuilder builder() {
        return new ZeebeWorkerValueBuilder();
    }

    public String toString() {
        return "ZeebeWorkerValue{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", timeout=" + this.timeout + ", maxJobsActive=" + this.maxJobsActive + ", requestTimeout=" + this.requestTimeout + ", pollInterval=" + this.pollInterval + ", autoComplete=" + this.autoComplete + ", fetchVariables=" + Arrays.toString(this.fetchVariables) + ", methodInfo=" + this.methodInfo + '}';
    }

    public static final class ZeebeWorkerValueBuilder {
        private String type;
        private String name;
        private long timeout;
        private int maxJobsActive;
        private long requestTimeout;
        private long pollInterval;
        private String[] fetchVariables;
        private boolean forceFetchAllVariables;
        private List<ParameterInfo> variableParameters;
        private boolean autoComplete;
        private MethodInfo methodInfo;

        private ZeebeWorkerValueBuilder() {
        }

        public ZeebeWorkerValueBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ZeebeWorkerValueBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ZeebeWorkerValueBuilder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public ZeebeWorkerValueBuilder maxJobsActive(int maxJobsActive) {
            this.maxJobsActive = maxJobsActive;
            return this;
        }

        public ZeebeWorkerValueBuilder requestTimeout(long requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ZeebeWorkerValueBuilder pollInterval(long pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public ZeebeWorkerValueBuilder fetchVariables(String[] fetchVariables) {
            this.fetchVariables = fetchVariables;
            return this;
        }

        public ZeebeWorkerValueBuilder forceFetchAllVariables(boolean forceFetchAllVariables) {
            this.forceFetchAllVariables = forceFetchAllVariables;
            return this;
        }

        public ZeebeWorkerValueBuilder autoComplete(boolean autoComplete) {
            this.autoComplete = autoComplete;
            return this;
        }

        public ZeebeWorkerValueBuilder methodInfo(MethodInfo methodInfo) {
            this.methodInfo = methodInfo;
            return this;
        }

        public ZeebeWorkerValueBuilder variableParameters(List<ParameterInfo> variableParameters) {
            this.variableParameters = variableParameters;
            return this;
        }

        public ZeebeWorkerValue build() {
            return new ZeebeWorkerValue(this.type, this.name, this.timeout, this.maxJobsActive, this.requestTimeout, this.pollInterval, this.fetchVariables, this.forceFetchAllVariables, this.variableParameters, this.autoComplete, this.methodInfo);
        }
    }
}

