/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.processor;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.spring.client.annotation.ZeebeDeployment;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeDeploymentValue;
import io.camunda.zeebe.spring.client.annotation.value.factory.ReadZeebeDeploymentValue;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ZeebeDeploymentAnnotationProcessor
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private final ReadZeebeDeploymentValue reader;
    private List<ZeebeDeploymentValue> deploymentValues = new ArrayList<ZeebeDeploymentValue>();

    public ZeebeDeploymentAnnotationProcessor(ReadZeebeDeploymentValue reader) {
        this.reader = reader;
    }

    @Override
    public boolean isApplicableFor(ClassInfo beanInfo) {
        return beanInfo.hasClassAnnotation(ZeebeDeployment.class);
    }

    @Override
    public void configureFor(ClassInfo beanInfo) {
        ZeebeDeploymentValue value = (ZeebeDeploymentValue)this.reader.applyOrThrow(beanInfo);
        LOGGER.info("Configuring deployment: {}", (Object)value);
        this.deploymentValues.add(value);
    }

    @Override
    public void start(ZeebeClient client) {
        this.deploymentValues.forEach(deployment -> {
            DeployResourceCommandStep1 deployResourceCommand = client.newDeployResourceCommand();
            DeploymentEvent deploymentResult = (DeploymentEvent)deployment.getResources().stream().flatMap(resource -> Stream.of(this.getResources((String)resource))).map(resource -> {
                DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2;
                block8: {
                    InputStream inputStream = resource.getInputStream();
                    try {
                        deployResourceCommandStep2 = deployResourceCommand.addResourceStream(inputStream, resource.getFilename());
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                    inputStream.close();
                }
                return deployResourceCommandStep2;
            }).filter(Objects::nonNull).reduce((first, second) -> second).orElseThrow(() -> new IllegalArgumentException("Requires at least one resource to deploy")).send().join();
            LOGGER.info("Deployed: {}", (Object)Stream.concat(deploymentResult.getDecisionRequirements().stream().map(wf -> String.format("<%s:%d>", wf.getDmnDecisionRequirementsId(), wf.getVersion())), deploymentResult.getProcesses().stream().map(wf -> String.format("<%s:%d>", wf.getBpmnProcessId(), wf.getVersion()))).collect(Collectors.joining(",")));
        });
    }

    @Override
    public void stop(ZeebeClient client) {
    }

    public Resource[] getResources(String resources) {
        try {
            return resourceResolver.getResources(resources);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }
}

