/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.processor;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.spring.client.annotation.ZeebeWorker;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.annotation.value.factory.ReadZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobHandlerInvokingSpringBeans;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ZeebeWorkerAnnotationProcessor
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ReadZeebeWorkerValue reader;
    private final DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final BackoffSupplier backoffSupplier;
    private String beanName = null;
    private List<ZeebeWorkerValue> zeebeWorkerValues = new ArrayList<ZeebeWorkerValue>();
    private List<JobWorker> openedWorkers = new ArrayList<JobWorker>();

    public ZeebeWorkerAnnotationProcessor(ReadZeebeWorkerValue reader, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, BackoffSupplier backoffSupplier) {
        this.reader = reader;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.backoffSupplier = backoffSupplier;
    }

    @Override
    public boolean isApplicableFor(ClassInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(ZeebeWorker.class);
    }

    @Override
    public void configureFor(ClassInfo beanInfo) {
        ArrayList newZeebeWorkerValues = new ArrayList();
        ReflectionUtils.doWithMethods(beanInfo.getTargetClass(), method -> this.reader.apply(beanInfo.toMethodInfo(method)).ifPresent(newZeebeWorkerValues::add), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        this.beanName = beanInfo.getBeanName();
        LOGGER.info("Configuring {} Zeebe worker(s) of bean '{}': {}", new Object[]{newZeebeWorkerValues.size(), this.beanName, newZeebeWorkerValues});
        this.zeebeWorkerValues.addAll(newZeebeWorkerValues);
    }

    @Override
    public void start(ZeebeClient client) {
        this.zeebeWorkerValues.forEach(zeebeWorkerValue -> {
            JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = client.newWorker().jobType(zeebeWorkerValue.getType()).handler((JobHandler)new JobHandlerInvokingSpringBeans((ZeebeWorkerValue)zeebeWorkerValue, this.commandExceptionHandlingStrategy));
            if (zeebeWorkerValue.getName() != null && zeebeWorkerValue.getName().length() > 0) {
                builder.name(zeebeWorkerValue.getName());
            } else if (null != client.getConfiguration().getDefaultJobWorkerName()) {
                builder.name(client.getConfiguration().getDefaultJobWorkerName());
            } else {
                builder.name(this.beanName + "#" + zeebeWorkerValue.getMethodInfo().getMethodName());
            }
            if (zeebeWorkerValue.getMaxJobsActive() > 0) {
                builder.maxJobsActive(zeebeWorkerValue.getMaxJobsActive());
            }
            if (zeebeWorkerValue.getTimeout() > 0L) {
                builder.timeout(zeebeWorkerValue.getTimeout());
            }
            if (zeebeWorkerValue.getPollInterval() > 0L) {
                builder.pollInterval(Duration.ofMillis(zeebeWorkerValue.getPollInterval()));
            }
            if (zeebeWorkerValue.getRequestTimeout() > 0L) {
                builder.requestTimeout(Duration.ofSeconds(zeebeWorkerValue.getRequestTimeout()));
            }
            if (zeebeWorkerValue.getFetchVariables().length > 0) {
                builder.fetchVariables(zeebeWorkerValue.getFetchVariables());
            }
            JobWorker jobWorker = builder.open();
            this.openedWorkers.add(jobWorker);
            LOGGER.info(". Starting Zeebe worker: {}", zeebeWorkerValue);
        });
    }

    @Override
    public void stop(ZeebeClient zeebeClient) {
        this.openedWorkers.forEach(worker -> worker.close());
        this.openedWorkers = new ArrayList<JobWorker>();
    }
}

