/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.lifecycle;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployProcessCommandStep1;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.command.TopologyRequestStep1;
import io.camunda.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.spring.client.annotation.processor.ZeebeAnnotationProcessorRegistry;
import io.camunda.zeebe.spring.client.event.ClientStartedEvent;
import io.camunda.zeebe.spring.client.lifecycle.ZeebeClientObjectFactory;
import java.util.function.Supplier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;

public class ZeebeClientLifecycle
implements ZeebeClient,
SmartLifecycle,
Supplier<ZeebeClient> {
    public static final int PHASE = 22222;
    protected boolean autoStartup = true;
    protected boolean running = false;
    protected boolean runningInTestContext = false;
    private final ZeebeAnnotationProcessorRegistry annotationProcessorRegistry;
    private final ApplicationEventPublisher publisher;
    protected final ZeebeClientObjectFactory factory;
    protected ZeebeClient delegate;

    public ZeebeClientLifecycle(ZeebeClientObjectFactory factory, ZeebeAnnotationProcessorRegistry annotationProcessorRegistry, ApplicationEventPublisher publisher) {
        this.factory = factory;
        this.annotationProcessorRegistry = annotationProcessorRegistry;
        this.publisher = publisher;
    }

    public void start() {
        this.delegate = (ZeebeClient)this.factory.getObject();
        if (this.delegate == null) {
            this.runningInTestContext = true;
        } else {
            this.running = true;
            this.publisher.publishEvent((Object)new ClientStartedEvent());
            this.annotationProcessorRegistry.startAll(this);
        }
    }

    public void stop() {
        try {
            this.delegate.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.running = false;
        }
        this.annotationProcessorRegistry.stopAll(this);
    }

    public void close() {
    }

    @Override
    public ZeebeClient get() {
        if (!this.isRunning()) {
            throw new IllegalStateException("ZeebeClient is not yet created!");
        }
        return this.delegate;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 22222;
    }

    public ZeebeClientConfiguration getConfiguration() {
        return this.get().getConfiguration();
    }

    public TopologyRequestStep1 newTopologyRequest() {
        return this.get().newTopologyRequest();
    }

    public DeployProcessCommandStep1 newDeployCommand() {
        return this.get().newDeployCommand();
    }

    public DeployResourceCommandStep1 newDeployResourceCommand() {
        return this.get().newDeployResourceCommand();
    }

    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand() {
        return this.get().newCreateInstanceCommand();
    }

    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long workflowInstanceKey) {
        return this.get().newCancelInstanceCommand(workflowInstanceKey);
    }

    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return this.get().newSetVariablesCommand(elementInstanceKey);
    }

    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return this.get().newPublishMessageCommand();
    }

    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return this.get().newResolveIncidentCommand(incidentKey);
    }

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return this.get().newUpdateRetriesCommand(jobKey);
    }

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(ActivatedJob job) {
        return this.newUpdateRetriesCommand(job.getKey());
    }

    public JobWorkerBuilderStep1 newWorker() {
        return this.get().newWorker();
    }

    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return this.get().newActivateJobsCommand();
    }

    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return this.get().newCompleteCommand(jobKey);
    }

    public CompleteJobCommandStep1 newCompleteCommand(ActivatedJob job) {
        return this.newCompleteCommand(job.getKey());
    }

    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return this.get().newFailCommand(jobKey);
    }

    public FailJobCommandStep1 newFailCommand(ActivatedJob job) {
        return this.newFailCommand(job.getKey());
    }

    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return this.get().newThrowErrorCommand(jobKey);
    }

    public ThrowErrorCommandStep1 newThrowErrorCommand(ActivatedJob job) {
        return this.newThrowErrorCommand(job.getKey());
    }
}

