/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client;

import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.impl.worker.ExponentialBackoffBuilderImpl;
import io.camunda.zeebe.spring.client.annotation.processor.AnnotationProcessorConfiguration;
import io.camunda.zeebe.spring.client.annotation.value.factory.ReadAnnotationValueConfiguration;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={AnnotationProcessorConfiguration.class, ReadAnnotationValueConfiguration.class})
public abstract class AbstractZeebeBaseClientSpringConfiguration {
    @Bean
    public DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy() {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), this.scheduledExecutorService());
    }

    @Bean
    public ScheduledExecutorService scheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    @Bean
    public BackoffSupplier backoffSupplier() {
        return new ExponentialBackoffBuilderImpl().maxDelay(1000L).minDelay(50L).backoffFactor(1.5).jitterFactor(0.2).build();
    }
}

