/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client;

import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.api.secret.SecretStore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.impl.worker.ExponentialBackoffBuilderImpl;
import io.camunda.zeebe.spring.client.annotation.processor.AnnotationProcessorConfiguration;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import io.camunda.zeebe.spring.client.jobhandling.SpringSecretProvider;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Import(value={AnnotationProcessorConfiguration.class})
public abstract class AbstractZeebeBaseClientSpringConfiguration {
    @Bean
    public DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy() {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), this.scheduledExecutorService());
    }

    @Bean
    public SecretStore secretStore(Environment env) {
        return new SecretStore((SecretProvider)new SpringSecretProvider(env));
    }

    @Bean
    public JobWorkerManager jobWorkerManager(DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, SecretStore secretStore, @Autowired(required=false) JsonMapper jsonMapper) {
        return new JobWorkerManager(commandExceptionHandlingStrategy, secretStore, jsonMapper);
    }

    @Bean
    public ScheduledExecutorService scheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    @Bean
    public BackoffSupplier backoffSupplier() {
        return new ExponentialBackoffBuilderImpl().maxDelay(1000L).minDelay(50L).backoffFactor(1.5).jitterFactor(0.2).build();
    }
}

