/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.processor;

import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.annotation.value.OutboundConnectorValue;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectorAnnotationProcessor
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<OutboundConnectorValue> outboundConnectors = new ArrayList<OutboundConnectorValue>();
    private final JobWorkerManager jobWorkerManager;

    public OutboundConnectorAnnotationProcessor(JobWorkerManager jobWorkerManager) {
        this.jobWorkerManager = jobWorkerManager;
    }

    @Override
    public boolean isApplicableFor(ClassInfo beanInfo) {
        return beanInfo.hasClassAnnotation(OutboundConnector.class);
    }

    @Override
    public void configureFor(ClassInfo beanInfo) {
        Optional<OutboundConnector> annotation = beanInfo.getAnnotation(OutboundConnector.class);
        if (annotation.isPresent()) {
            OutboundConnectorValue connector = new OutboundConnectorValue().setBeanInfo(beanInfo).setType(annotation.get().type()).setName(annotation.get().name()).setInputVariables(annotation.get().inputVariables());
            LOGGER.info("Configuring outbound connector {} of bean '{}'", (Object)connector, (Object)beanInfo.getBeanName());
            this.outboundConnectors.add(connector);
        }
    }

    @Override
    public void start(ZeebeClient client) {
        this.outboundConnectors.forEach(connector -> {
            ZeebeWorkerValue zeebeWorkerValue = new ZeebeWorkerValue().setName(connector.getName()).setType(connector.getType()).setAutoComplete(true);
            JobWorker jobWorker = this.jobWorkerManager.openWorker(client, zeebeWorkerValue, (OutboundConnectorFunction)connector.getBeanInfo().getBean());
        });
    }

    @Override
    public void stop(ZeebeClient client) {
        this.jobWorkerManager.closeAllOpenWorkers();
    }
}

