/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.api.secret.SecretStore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.spring.client.annotation.CustomHeaders;
import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.annotation.VariablesAsType;
import io.camunda.zeebe.spring.client.annotation.ZeebeCustomHeaders;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariable;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariablesAsType;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.copy.JobHandlerContext;
import io.camunda.zeebe.spring.client.jobhandling.copy.OutboundConnectorFunctionInvoker;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JobHandlerInvokingSpringBeans
implements JobHandler {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
    private ZeebeWorkerValue workerValue;
    private DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private SecretStore secretStore;
    private OutboundConnectorFunction outboundConnectorFunction;
    private JsonMapper jsonMapper;

    public JobHandlerInvokingSpringBeans(ZeebeWorkerValue workerValue, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, JsonMapper jsonMapper) {
        this.workerValue = workerValue;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.jsonMapper = jsonMapper;
    }

    public JobHandlerInvokingSpringBeans(ZeebeWorkerValue workerValue, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, SecretStore secretStore, OutboundConnectorFunction outboundConnectorFunction, JsonMapper jsonMapper) {
        this.workerValue = workerValue;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.secretStore = secretStore;
        this.outboundConnectorFunction = outboundConnectorFunction;
        this.jsonMapper = jsonMapper;
    }

    public void handle(JobClient jobClient, ActivatedJob job) throws Exception {
        try {
            Object result = null;
            if (this.outboundConnectorFunction != null) {
                JobHandlerContext jobHandlerContext = this.createJobHandlerContext(job);
                result = new OutboundConnectorFunctionInvoker().execute(this.outboundConnectorFunction, jobHandlerContext, job);
            } else {
                List<Object> args = this.createParameters(jobClient, job, this.workerValue.getMethodInfo().getParameters());
                result = this.workerValue.getMethodInfo().invoke(args.toArray());
            }
            if (this.workerValue.getAutoComplete().booleanValue()) {
                CommandWrapper command = new CommandWrapper((FinalCommandStep<Void>)this.createCompleteCommand(jobClient, job, result), job, this.commandExceptionHandlingStrategy);
                command.executeAsync();
            }
        }
        catch (ZeebeBpmnError bpmnError) {
            CommandWrapper command = new CommandWrapper(this.createThrowErrorCommand(jobClient, job, bpmnError), job, this.commandExceptionHandlingStrategy);
            command.executeAsync();
        }
    }

    private List<Object> createParameters(JobClient jobClient, ActivatedJob job, List<ParameterInfo> parameters) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (ParameterInfo param : parameters) {
            Object arg = null;
            Class<?> clazz = param.getParameterInfo().getType();
            if (JobClient.class.isAssignableFrom(clazz)) {
                arg = jobClient;
            } else if (ActivatedJob.class.isAssignableFrom(clazz)) {
                arg = job;
            } else {
                if (param.getParameterInfo().isAnnotationPresent(Variable.class) || param.getParameterInfo().isAnnotationPresent(ZeebeVariable.class)) {
                    String paramName = param.getParameterName();
                    Object variableValue = job.getVariablesAsMap().get(paramName);
                    try {
                        arg = this.mapZeebeVariable(variableValue, param.getParameterInfo().getType());
                    }
                    catch (ClassCastException | IllegalArgumentException ex) {
                        throw new RuntimeException("Cannot assign process variable '" + paramName + "' to parameter when executing job '" + job.getType() + "', invalid type found: " + ex.getMessage());
                    }
                }
                if (param.getParameterInfo().isAnnotationPresent(VariablesAsType.class) || param.getParameterInfo().isAnnotationPresent(ZeebeVariablesAsType.class)) {
                    try {
                        arg = job.getVariablesAsType(clazz);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Cannot assign process variables to type '" + clazz.getName() + "' when executing job '" + job.getType() + "', cause is: " + e.getMessage(), e);
                    }
                }
                if (param.getParameterInfo().isAnnotationPresent(CustomHeaders.class) || param.getParameterInfo().isAnnotationPresent(ZeebeCustomHeaders.class)) {
                    try {
                        arg = job.getCustomHeaders();
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Cannot assign headers '" + param.getParameterName() + "' to parameter when executing job '" + job.getType() + "', cause is: " + e.getMessage(), e);
                    }
                }
            }
            args.add(arg);
        }
        return args;
    }

    protected JobHandlerContext createJobHandlerContext(ActivatedJob job) {
        return new JobHandlerContext(job, this.secretStore);
    }

    public FinalCommandStep createCompleteCommand(JobClient jobClient, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        if (result != null) {
            completeCommand = result.getClass().isAssignableFrom(Map.class) ? completeCommand.variables((Map)result) : (result.getClass().isAssignableFrom(String.class) ? completeCommand.variables((String)result) : (result.getClass().isAssignableFrom(InputStream.class) ? completeCommand.variables((InputStream)result) : completeCommand.variables(result)));
        }
        return completeCommand;
    }

    private FinalCommandStep<Void> createThrowErrorCommand(JobClient jobClient, ActivatedJob job, ZeebeBpmnError bpmnError) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 command = jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorMessage());
        return command;
    }

    private <T> T mapZeebeVariable(Object toMap, Class<T> clazz) {
        if (toMap != null && !clazz.isInstance(toMap)) {
            if (this.jsonMapper != null) {
                return (T)this.jsonMapper.fromJson(this.jsonMapper.toJson(toMap), clazz);
            }
            return (T)DEFAULT_OBJECT_MAPPER.convertValue(toMap, clazz);
        }
        return clazz.cast(toMap);
    }
}

