/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling.copy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.camunda.zeebe.spring.client.jobhandling.copy.FeelEngineWrapperException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.impl.SpiServiceLoader;
import scala.collection.IterableOnce;
import scala.jdk.javaapi.CollectionConverters;
import scala.util.Either;

public class FeelEngineWrapper {
    static final String RESPONSE_MAP_KEY = "response";
    static final String ERROR_VARIABLES_MUST_NOT_BE_NULL = "variables cannot be null";
    static final String ERROR_EXPRESSION_EVALUATION_FAILED = "expression evaluation failed";
    static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final FeelEngine feelEngine;
    private final ObjectMapper objectMapper;

    public FeelEngineWrapper() {
        this(new FeelEngine.Builder().valueMapper(SpiServiceLoader.loadValueMapper()).functionProvider(SpiServiceLoader.loadFunctionProvider()).build(), new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS));
    }

    public FeelEngineWrapper(FeelEngine feelEngine, ObjectMapper objectMapper) {
        this.feelEngine = feelEngine;
        this.objectMapper = objectMapper;
    }

    private static String trimExpression(String expression) {
        String feelExpression = expression.trim();
        if (feelExpression.startsWith("=")) {
            feelExpression = feelExpression.substring(1);
        }
        return feelExpression.trim();
    }

    private static scala.collection.immutable.Map<String, Object> toScalaMap(Map<String, Object> responseMap) {
        HashMap<String, Object> context = new HashMap<String, Object>(responseMap);
        context.put(RESPONSE_MAP_KEY, responseMap);
        return scala.collection.immutable.Map.from((IterableOnce)CollectionConverters.asScala(context));
    }

    private Map<String, Object> ensureVariablesMap(Object variables) {
        Objects.requireNonNull(variables, ERROR_VARIABLES_MUST_NOT_BE_NULL);
        return (Map)this.objectMapper.convertValue(variables, MAP_TYPE_REFERENCE);
    }

    public String evaluateToJson(String expression, Object variables) {
        try {
            Map<String, Object> variablesAsMap = this.ensureVariablesMap(variables);
            scala.collection.immutable.Map<String, Object> variablesAsMapAsScalaMap = FeelEngineWrapper.toScalaMap(variablesAsMap);
            Either result = this.feelEngine.evalExpression(FeelEngineWrapper.trimExpression(expression), variablesAsMapAsScalaMap);
            if (result.isRight()) {
                return this.resultToJson(result.right().get());
            }
            throw new RuntimeException(((FeelEngine.Failure)result.left().get()).message());
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(ERROR_EXPRESSION_EVALUATION_FAILED, expression, variables, e);
        }
    }

    private String resultToJson(Object result) {
        try {
            return this.objectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

