/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling.copy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.impl.outbound.AbstractOutboundConnectorContext;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.spring.client.jobhandling.copy.FeelEngineWrapper;
import io.camunda.zeebe.spring.client.jobhandling.copy.FeelEngineWrapperException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OutboundConnectorFunctionInvoker {
    public static final String ERROR_CANNOT_PARSE_VARIABLES = "Cannot parse variables";
    public static final String RESULT_VARIABLE_HEADER_NAME = "resultVariable";
    public static final String RESULT_EXPRESSION_HEADER_NAME = "resultExpression";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final FeelEngineWrapper feelEngineWrapper = new FeelEngineWrapper();

    public Map<String, Object> execute(OutboundConnectorFunction function, AbstractOutboundConnectorContext context, ActivatedJob job) throws Exception {
        Object result = function.execute((OutboundConnectorContext)context);
        Map<String, Object> outputVariables = this.createOutputVariables(result, job.getCustomHeaders());
        return outputVariables;
    }

    protected Map<String, Object> createOutputVariables(Object responseContent, Map<String, String> jobHeaders) {
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        String resultVariableName = jobHeaders.get(RESULT_VARIABLE_HEADER_NAME);
        String resultExpression = jobHeaders.get(RESULT_EXPRESSION_HEADER_NAME);
        if (resultVariableName != null) {
            outputVariables.put(resultVariableName, responseContent);
        }
        Optional.ofNullable(resultExpression).map(expression -> this.feelEngineWrapper.evaluateToJson((String)expression, responseContent)).map(json -> this.parseJsonVarsAsMapOrThrow((String)json, resultExpression)).ifPresent(outputVariables::putAll);
        return outputVariables;
    }

    private Map<String, Object> parseJsonVarsAsMapOrThrow(String jsonVars, String expression) {
        try {
            return (Map)OBJECT_MAPPER.readValue(jsonVars, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new FeelEngineWrapperException(ERROR_CANNOT_PARSE_VARIABLES, expression, jsonVars, e);
        }
    }
}

