/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.connector;

import io.camunda.connector.impl.config.ConnectorPropertyResolver;
import org.springframework.core.env.Environment;

public class SpringConnectorPropertyResolver
implements ConnectorPropertyResolver {
    private final Environment environment;

    public SpringConnectorPropertyResolver(Environment environment) {
        this.environment = environment;
    }

    public boolean containsProperty(String key) {
        if (this.environment.containsProperty(key)) {
            return true;
        }
        return this.environment.containsProperty(this.createSpringFormattedKey(key));
    }

    public String getProperty(String key) {
        if (this.environment.containsProperty(key)) {
            return this.environment.getProperty(key);
        }
        String alternativeKey = this.createSpringFormattedKey(key);
        if (this.environment.containsProperty(alternativeKey)) {
            return this.environment.getProperty(alternativeKey);
        }
        return null;
    }

    private String createSpringFormattedKey(String key) {
        return key.toLowerCase().replaceAll("_", ".");
    }
}

