/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client;

import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.impl.worker.ExponentialBackoffBuilderImpl;
import io.camunda.zeebe.spring.client.annotation.processor.AnnotationProcessorConfiguration;
import io.camunda.zeebe.spring.client.connector.ConnectorConfiguration;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import io.camunda.zeebe.spring.client.metrics.DefaultNoopMetricsRecorder;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Import(value={AnnotationProcessorConfiguration.class, ConnectorConfiguration.class})
public abstract class AbstractZeebeBaseClientSpringConfiguration {
    @Bean
    @Conditional(value={OnMissingCommandExceptionHandlingStrategy.class})
    public CommandExceptionHandlingStrategy commandExceptionHandlingStrategy() {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), this.scheduledExecutorService());
    }

    @Bean
    public JobWorkerManager jobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, SecretProvider secretProvider, @Autowired(required=false) JsonMapper jsonMapper, @Autowired(required=false) MetricsRecorder metricsRecorder) {
        if (metricsRecorder == null) {
            metricsRecorder = new DefaultNoopMetricsRecorder();
        }
        return new JobWorkerManager(commandExceptionHandlingStrategy, secretProvider, jsonMapper, metricsRecorder);
    }

    @Bean
    public ScheduledExecutorService scheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    @Bean
    public BackoffSupplier backoffSupplier() {
        return new ExponentialBackoffBuilderImpl().maxDelay(1000L).minDelay(50L).backoffFactor(1.5).jitterFactor(0.2).build();
    }

    public static class OnMissingCommandExceptionHandlingStrategy
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return context.getBeanFactory().getBeanNamesForType(CommandExceptionHandlingStrategy.class).length <= 0;
        }
    }
}

