/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobHandlerInvokingSpringBeans;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final SecretProvider secretProvider;
    private final JsonMapper jsonMapper;
    private final MetricsRecorder metricsRecorder;
    private List<JobWorker> openedWorkers = new ArrayList<JobWorker>();
    private List<ZeebeWorkerValue> workerValues = new ArrayList<ZeebeWorkerValue>();

    public JobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, SecretProvider secretProvider, JsonMapper jsonMapper, MetricsRecorder metricsRecorder) {
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.secretProvider = secretProvider;
        this.jsonMapper = jsonMapper;
        this.metricsRecorder = metricsRecorder;
    }

    public JobWorker openWorker(ZeebeClient client, ZeebeWorkerValue zeebeWorkerValue) {
        return this.openWorker(client, zeebeWorkerValue, new JobHandlerInvokingSpringBeans(zeebeWorkerValue, this.commandExceptionHandlingStrategy, this.jsonMapper, this.metricsRecorder));
    }

    public JobWorker openWorker(ZeebeClient client, ZeebeWorkerValue zeebeWorkerValue, OutboundConnectorConfiguration connector) {
        return this.openWorker(client, zeebeWorkerValue, new JobHandlerInvokingSpringBeans(zeebeWorkerValue, this.commandExceptionHandlingStrategy, this.secretProvider, connector, this.jsonMapper, this.metricsRecorder));
    }

    public JobWorker openWorker(ZeebeClient client, ZeebeWorkerValue zeebeWorkerValue, JobHandler handler) {
        JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = client.newWorker().jobType(zeebeWorkerValue.getType()).handler(handler).name(zeebeWorkerValue.getName());
        if (zeebeWorkerValue.getMaxJobsActive() != null && zeebeWorkerValue.getMaxJobsActive() > 0) {
            builder.maxJobsActive(zeebeWorkerValue.getMaxJobsActive().intValue());
        }
        if (zeebeWorkerValue.getTimeout() != null && zeebeWorkerValue.getTimeout() > 0L) {
            builder.timeout(zeebeWorkerValue.getTimeout().longValue());
        }
        if (zeebeWorkerValue.getPollInterval() != null && zeebeWorkerValue.getPollInterval() > 0L) {
            builder.pollInterval(Duration.ofMillis(zeebeWorkerValue.getPollInterval()));
        }
        if (zeebeWorkerValue.getRequestTimeout() != null && zeebeWorkerValue.getRequestTimeout() > 0L) {
            builder.requestTimeout(Duration.ofSeconds(zeebeWorkerValue.getRequestTimeout()));
        }
        if (zeebeWorkerValue.getFetchVariables() != null && zeebeWorkerValue.getFetchVariables().length > 0) {
            builder.fetchVariables(zeebeWorkerValue.getFetchVariables());
        }
        JobWorker jobWorker = builder.open();
        this.openedWorkers.add(jobWorker);
        this.workerValues.add(zeebeWorkerValue);
        LOGGER.info(". Starting Zeebe worker: {}", (Object)zeebeWorkerValue);
        return jobWorker;
    }

    public void closeAllOpenWorkers() {
        this.openedWorkers.forEach(worker -> worker.close());
        this.openedWorkers = new ArrayList<JobWorker>();
    }

    public void closeWorker(JobWorker worker) {
        worker.close();
        int i = this.openedWorkers.indexOf(worker);
        this.openedWorkers.remove(i);
        this.workerValues.remove(i);
    }

    public Optional<ZeebeWorkerValue> findJobWorkerConfigByName(String name) {
        return this.workerValues.stream().filter(worker -> worker.getName().equals(name)).findFirst();
    }

    public Optional<ZeebeWorkerValue> findJobWorkerConfigByType(String type) {
        return this.workerValues.stream().filter(worker -> worker.getType().equals(type)).findFirst();
    }
}

