/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.operate.CamundaOperateClientConfiguration;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.http.DefaultHttpClient;
import io.camunda.operate.http.HttpClient;
import io.camunda.operate.model.ChangeStatus;
import io.camunda.operate.model.DecisionDefinition;
import io.camunda.operate.model.DecisionInstance;
import io.camunda.operate.model.DecisionRequirements;
import io.camunda.operate.model.FlowNodeInstance;
import io.camunda.operate.model.FlowNodeStatistics;
import io.camunda.operate.model.Incident;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.operate.model.ProcessInstance;
import io.camunda.operate.model.SearchResult;
import io.camunda.operate.model.TypeReferences;
import io.camunda.operate.model.Variable;
import io.camunda.operate.search.DecisionDefinitionFilter;
import io.camunda.operate.search.DecisionInstanceFilter;
import io.camunda.operate.search.DecisionRequirementsFilter;
import io.camunda.operate.search.Filter;
import io.camunda.operate.search.FlowNodeInstanceFilter;
import io.camunda.operate.search.IncidentFilter;
import io.camunda.operate.search.ProcessDefinitionFilter;
import io.camunda.operate.search.ProcessInstanceFilter;
import io.camunda.operate.search.SearchQuery;
import io.camunda.operate.search.VariableFilter;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CamundaOperateClient {
    private final HttpClient httpClient;

    private CamundaOperateClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CamundaOperateClient(CamundaOperateClientConfiguration configuration) {
        this(CamundaOperateClient.buildOperateHttpClient(configuration));
    }

    private static HttpClient buildOperateHttpClient(CamundaOperateClientConfiguration configuration) {
        HashMap map = new HashMap();
        map.put(TypeReferences.searchProcessDefinition, "/process-definitions/search");
        map.put(TypeReferences.processDefinition, "/process-definitions/{key}");
        map.put(TypeReferences.processDefinitionXml, "/process-definitions/{key}/xml");
        map.put(TypeReferences.searchDecisionDefinition, "/decision-definitions/search");
        map.put(TypeReferences.decisionDefinition, "/decision-definitions/{key}");
        map.put(TypeReferences.searchDecisionInstance, "/decision-instances/search");
        map.put(TypeReferences.decisionInstance, "/decision-instances/{id}");
        map.put(TypeReferences.searchFlowNodeInstance, "/flownode-instances/search");
        map.put(TypeReferences.flowNodeInstance, "/flownode-instances/{key}");
        map.put(TypeReferences.searchVariable, "/variables/search");
        map.put(TypeReferences.variable, "/variables/{key}");
        map.put(TypeReferences.searchProcessInstance, "/process-instances/search");
        map.put(TypeReferences.processInstance, "/process-instances/{key}");
        map.put(TypeReferences.deleteProcessInstance, "/process-instances/{key}");
        map.put(TypeReferences.flownodeStatistics, "/process-instances/{key}/statistics");
        map.put(TypeReferences.sequenceFlows, "/process-instances/{key}/sequence-flows");
        map.put(TypeReferences.searchDecisionRequirements, "/drd/search");
        map.put(TypeReferences.decisionRequirements, "/drd/{key}");
        map.put(TypeReferences.decisionRequirementsXml, "/drd/{key}/xml");
        map.put(TypeReferences.searchIncident, "/incidents/search");
        map.put(TypeReferences.incident, "/incidents/{key}");
        try {
            return new DefaultHttpClient(URI.create(CamundaOperateClient.formatUrl(configuration.baseUrl().toString() + "/v1")).toURL(), configuration.authentication(), configuration.httpClient(), configuration.objectMapper(), map);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while initializing operate http client", e);
        }
    }

    private static String formatUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public ProcessDefinition getProcessDefinition(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.processDefinition, this.key(key));
    }

    public BpmnModelInstance getProcessDefinitionModel(Long key) throws OperateException {
        String xml = this.getProcessDefinitionXml(key);
        try {
            ByteArrayInputStream processInputStream = new ByteArrayInputStream(xml.getBytes());
            return Bpmn.readModelFromStream((InputStream)processInputStream);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    public String getProcessDefinitionXml(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.processDefinitionXml, this.key(key));
    }

    public List<ProcessDefinition> searchProcessDefinitions(SearchQuery query) throws OperateException {
        return this.searchProcessDefinitionResults(query).getItems();
    }

    public SearchResult<ProcessDefinition> searchProcessDefinitionResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(ProcessDefinitionFilter.class, query);
        return this.httpClient.post(TypeReferences.searchProcessDefinition, query);
    }

    public List<DecisionDefinition> searchDecisionDefinitions(SearchQuery query) throws OperateException {
        return this.searchDecisionDefinitionResults(query).getItems();
    }

    public SearchResult<DecisionDefinition> searchDecisionDefinitionResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(DecisionDefinitionFilter.class, query);
        return this.httpClient.post(TypeReferences.searchDecisionDefinition, query);
    }

    public List<DecisionInstance> searchDecisionInstances(SearchQuery query) throws OperateException {
        return this.searchDecisionInstanceResults(query).getItems();
    }

    public SearchResult<DecisionInstance> searchDecisionInstanceResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(DecisionInstanceFilter.class, query);
        return this.httpClient.post(TypeReferences.searchDecisionInstance, query);
    }

    public List<FlowNodeInstance> searchFlowNodeInstances(SearchQuery query) throws OperateException {
        return this.searchFlowNodeInstanceResults(query).getItems();
    }

    public SearchResult<FlowNodeInstance> searchFlowNodeInstanceResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(FlowNodeInstanceFilter.class, query);
        return this.httpClient.post(TypeReferences.searchFlowNodeInstance, query);
    }

    public List<Variable> searchVariables(SearchQuery query) throws OperateException {
        return this.searchVariableResults(query).getItems();
    }

    public SearchResult<Variable> searchVariableResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(VariableFilter.class, query);
        return this.httpClient.post(TypeReferences.searchVariable, query);
    }

    public List<ProcessInstance> searchProcessInstances(SearchQuery query) throws OperateException {
        return this.searchProcessInstanceResults(query).getItems();
    }

    public SearchResult<ProcessInstance> searchProcessInstanceResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(ProcessInstanceFilter.class, query);
        return this.httpClient.post(TypeReferences.searchProcessInstance, query);
    }

    public List<DecisionRequirements> searchDecisionRequirements(SearchQuery query) throws OperateException {
        return this.searchDecisionRequirementsResults(query).getItems();
    }

    public SearchResult<DecisionRequirements> searchDecisionRequirementsResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(DecisionRequirementsFilter.class, query);
        return this.httpClient.post(TypeReferences.searchDecisionRequirements, query);
    }

    public List<Incident> searchIncidents(SearchQuery query) throws OperateException {
        return this.searchIncidentResults(query).getItems();
    }

    public SearchResult<Incident> searchIncidentResults(SearchQuery query) throws OperateException {
        this.assertSearchQueryType(IncidentFilter.class, query);
        return this.httpClient.post(TypeReferences.searchIncident, query);
    }

    public ProcessInstance getProcessInstance(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.processInstance, Map.of("key", String.valueOf(key)));
    }

    public ChangeStatus deleteProcessInstance(Long key) throws OperateException {
        return this.httpClient.delete(TypeReferences.deleteProcessInstance, this.key(key));
    }

    public List<FlowNodeStatistics> getFlowNodeStatistics(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.flownodeStatistics, this.key(key));
    }

    public List<String> getSequenceFlows(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.sequenceFlows, this.key(key));
    }

    public FlowNodeInstance getFlowNodeInstance(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.flowNodeInstance, this.key(key));
    }

    public Incident getIncident(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.incident, this.key(key));
    }

    public DecisionDefinition getDecisionDefinition(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.decisionDefinition, this.key(key));
    }

    public DecisionRequirements getDecisionRequirements(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.decisionRequirements, this.key(key));
    }

    public String getDecisionRequirementsXml(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.decisionRequirementsXml, this.key(key));
    }

    public DecisionInstance getDecisionInstance(String id) throws OperateException {
        return this.httpClient.get(TypeReferences.decisionInstance, Map.of("id", id));
    }

    public Variable getVariable(Long key) throws OperateException {
        return this.httpClient.get(TypeReferences.variable, this.key(key));
    }

    private Map<String, String> key(Long key) {
        return Map.of("key", String.valueOf(key));
    }

    private void assertSearchQueryType(Class<? extends Filter> type, SearchQuery query) {
        if (query.getFilter() != null && !query.getFilter().getClass().isAssignableFrom(type)) {
            throw new IllegalStateException("Expected filter of type " + String.valueOf(type) + " but got " + String.valueOf(query.getFilter().getClass()));
        }
    }
}

