/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.http;

import io.camunda.operate.http.ErrorCodeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorCodeHandler
implements ErrorCodeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultErrorCodeHandler.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RuntimeException handleError(ClassicHttpResponse response) {
        String message = "Unsuccessful response: Code " + response.getCode() + (String)(response.getReasonPhrase() == null ? "" : " " + response.getReasonPhrase());
        try (InputStream content = response.getEntity().getContent();){
            if (content == null) return new RuntimeException(message);
            StringWriter writer = new StringWriter();
            InputStreamReader reader = new InputStreamReader(content);
            reader.transferTo(writer);
            String errorBody = writer.toString();
            RuntimeException runtimeException = new RuntimeException(message + ", body: " + errorBody);
            return runtimeException;
        }
        catch (IOException e) {
            LOG.debug("Error while reading error response", (Throwable)e);
        }
        return new RuntimeException(message);
    }
}

