/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.camunda.operate.model.DateFilterRange;
import io.camunda.operate.serializer.OperateDateDeserializer;
import io.camunda.operate.serializer.OperateDateSerializer;
import java.util.Date;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonSerialize(using=OperateDateSerializer.class)
@JsonDeserialize(using=OperateDateDeserializer.class)
public interface OperateDate {
    public static OperateDate date(Date date) {
        return new SimpleOperateDate(date);
    }

    public static OperateDate filter(Date date, DateFilterRange range) {
        return new OperateDateFilter(date, range);
    }

    public static OperateDate empty() {
        return new SimpleOperateDate(null);
    }

    public Date getDate();

    public record SimpleOperateDate(Date date) implements OperateDate
    {
        @Override
        public Date getDate() {
            return this.date;
        }
    }

    public record OperateDateFilter(Date date, DateFilterRange range) implements OperateDate
    {
        @Override
        public Date getDate() {
            return this.date;
        }
    }
}

