/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.HttpClient;
import io.camunda.common.auth.JwtAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.TokenResponse;
import io.camunda.common.json.JsonMapper;
import io.camunda.common.json.SdkObjectMapper;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfManagedAuthentication
extends JwtAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String authUrl;
    private String keycloakRealm = "camunda-platform";
    private String keycloakUrl;
    private JwtConfig jwtConfig;
    private Map<Product, String> tokens;
    private JsonMapper jsonMapper = new SdkObjectMapper();

    public SelfManagedAuthentication() {
        this.tokens = new HashMap<Product, String>();
    }

    public static SelfManagedAuthenticationBuilder builder() {
        return new SelfManagedAuthenticationBuilder();
    }

    public void setKeycloakRealm(String keycloakRealm) {
        this.keycloakRealm = keycloakRealm;
    }

    public void setKeycloakUrl(String keycloakUrl) {
        this.keycloakUrl = keycloakUrl;
    }

    public void setJwtConfig(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    @Override
    public Authentication build() {
        this.authUrl = this.keycloakUrl + "/auth/realms/" + this.keycloakRealm + "/protocol/openid-connect/token";
        return this;
    }

    private String retrieveToken(Product product, JwtCredential jwtCredential) {
        try {
            HttpPost httpPost = new HttpPost(this.authUrl);
            httpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("grant_type", "client_credentials");
            parameters.put("client_id", jwtCredential.clientId);
            parameters.put("client_secret", jwtCredential.clientSecret);
            String form = parameters.entrySet().stream().map(e -> {
                try {
                    return (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.joining("&"));
            httpPost.setEntity((HttpEntity)new StringEntity(form));
            CloseableHttpClient client = HttpClient.getInstance();
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);
            TokenResponse tokenResponse = this.jsonMapper.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), TokenResponse.class);
            this.tokens.put(product, tokenResponse.getAccessToken());
        }
        catch (Exception e2) {
            LOG.error("Authenticating for " + (Object)((Object)product) + " failed due to " + e2);
            throw new RuntimeException("Unable to authenticate", e2);
        }
        return this.tokens.get((Object)product);
    }

    @Override
    public Map.Entry<String, String> getTokenHeader(Product product) {
        String token;
        if (this.tokens.containsKey((Object)product)) {
            token = this.tokens.get((Object)product);
        } else {
            JwtCredential jwtCredential = this.jwtConfig.getProduct(product);
            token = this.retrieveToken(product, jwtCredential);
        }
        return new AbstractMap.SimpleEntry<String, String>("Authorization", "Bearer " + token);
    }
}

