/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.HttpClient;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SimpleAuthenticationBuilder;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.SimpleCredential;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthentication
implements Authentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String simpleUrl;
    private SimpleConfig simpleConfig;
    private Map<Product, String> tokens = new HashMap<Product, String>();
    private String authUrl;

    public void setSimpleUrl(String simpleUrl) {
        this.simpleUrl = simpleUrl;
    }

    public void setSimpleConfig(SimpleConfig simpleConfig) {
        this.simpleConfig = simpleConfig;
    }

    public static SimpleAuthenticationBuilder builder() {
        return new SimpleAuthenticationBuilder();
    }

    @Override
    public Authentication build() {
        this.authUrl = this.simpleUrl + "/api/login";
        this.simpleConfig.getMap().forEach(this::retrieveToken);
        return this;
    }

    private void retrieveToken(Product product, SimpleCredential simpleCredential) {
        try {
            HttpPost httpPost = new HttpPost(this.authUrl);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("username", simpleCredential.user));
            params.add(new BasicNameValuePair("password", simpleCredential.password));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpClient client = HttpClient.getInstance();
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);
            String cookie = response.getHeader("Set-Cookie").getValue();
            this.tokens.put(product, cookie);
        }
        catch (Exception e) {
            LOG.error("Authenticating for " + (Object)((Object)product) + " failed due to " + e);
            throw new RuntimeException("Unable to authenticate", e);
        }
    }

    @Override
    public Map.Entry<String, String> getTokenHeader(Product product) {
        return new AbstractMap.SimpleEntry<String, String>("Cookie", this.tokens.get((Object)product));
    }
}

