/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.http;

import com.google.common.reflect.TypeToken;
import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.Product;
import io.camunda.common.http.HttpClient;
import io.camunda.common.http.Java8Utils;
import io.camunda.common.json.JsonMapper;
import io.camunda.common.json.SdkObjectMapper;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String host = "";
    private String basePath = "";
    private final Map<Product, Map<Class<?>, String>> productMap;
    private final CloseableHttpClient httpClient;
    private final Authentication authentication;
    private final JsonMapper jsonMapper;

    public DefaultHttpClient(Authentication authentication) {
        this.authentication = authentication;
        this.httpClient = HttpClients.createDefault();
        this.jsonMapper = new SdkObjectMapper();
        this.productMap = new HashMap();
    }

    public DefaultHttpClient(Authentication authentication, CloseableHttpClient httpClient, JsonMapper jsonMapper, Map<Product, Map<Class<?>, String>> productMap) {
        this.authentication = authentication;
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.productMap = productMap;
    }

    @Override
    public void init(String host, String basePath) {
        this.host = host;
        this.basePath = basePath;
    }

    @Override
    public void loadMap(Product product, Map<Class<?>, String> map) {
        this.productMap.put(product, map);
    }

    @Override
    public <T> T get(Class<T> responseType, Long key) {
        return this.get(responseType, String.valueOf(key));
    }

    @Override
    public <T> T get(Class<T> responseType, String id) {
        String url = this.host + this.basePath + this.retrievePath(responseType) + "/" + id;
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader(this.retrieveToken(responseType));
        T resp = null;
        try {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpGet);
            String tmp = new String(Java8Utils.readAllBytes(response.getEntity().getContent()), StandardCharsets.UTF_8);
            resp = this.jsonMapper.fromJson(tmp, responseType);
        }
        catch (Exception e) {
            LOG.error("Failed GET with responseType {}, id {} due to {}", new Object[]{responseType, id, e.getMessage()});
        }
        return resp;
    }

    @Override
    public <T, V, W> T get(Class<T> responseType, Class<V> parameterType, TypeToken<W> selector, Long key) {
        return this.get(responseType, parameterType, selector, String.valueOf(key));
    }

    private <T, V, W> T get(Class<T> responseType, Class<V> parameterType, TypeToken<W> selector, String id) {
        String resourcePath = this.retrievePath(selector.getClass());
        resourcePath = resourcePath.contains("{key}") ? resourcePath.replace("{key}", String.valueOf(id)) : resourcePath + "/" + id;
        String url = this.host + this.basePath + resourcePath;
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader(this.retrieveToken(selector.getClass()));
        T resp = null;
        try {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpGet);
            String tmp = new String(Java8Utils.readAllBytes(response.getEntity().getContent()), StandardCharsets.UTF_8);
            resp = this.jsonMapper.fromJson(tmp, responseType, parameterType);
        }
        catch (Exception e) {
            LOG.error("Failed GET with responseType {}, parameterType {}, selector {}, id {} due to {}", new Object[]{responseType, parameterType, selector, id, e.getMessage()});
        }
        return resp;
    }

    @Override
    public <T> String getXml(Class<T> selector, Long key) {
        String url = this.host + this.basePath + this.retrievePath(selector) + "/" + key + "/xml";
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader(this.retrieveToken(selector));
        String xml = null;
        try {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpGet);
            xml = new String(Java8Utils.readAllBytes(response.getEntity().getContent()), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Failed GET with selector {}, key {} due to {}", new Object[]{selector, key, e.getMessage()});
        }
        return xml;
    }

    @Override
    public <T, V, W, U> T post(Class<T> responseType, Class<V> parameterType, TypeToken<W> selector, U body) {
        String url = this.host + this.basePath + this.retrievePath(selector.getClass());
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", (Object)"application/json");
        httpPost.addHeader(this.retrieveToken(selector.getClass()));
        T resp = null;
        try {
            String data = this.jsonMapper.toJson(body);
            httpPost.setEntity((HttpEntity)new StringEntity(data));
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpPost);
            String tmp = new String(Java8Utils.readAllBytes(response.getEntity().getContent()), StandardCharsets.UTF_8);
            resp = this.jsonMapper.fromJson(tmp, responseType, parameterType);
        }
        catch (Exception e) {
            LOG.error("Failed POST with responseType {}, parameterType {}, selector {}, body {} due to {}", new Object[]{responseType, parameterType, selector, body, e.getMessage()});
        }
        return resp;
    }

    @Override
    public <T, V> T delete(Class<T> responseType, Class<V> selector, Long key) {
        String resourcePath = this.retrievePath(selector) + "/" + key;
        String url = this.host + this.basePath + resourcePath;
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.addHeader(this.retrieveToken(selector));
        T resp = null;
        try {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpDelete);
            String tmp = new String(Java8Utils.readAllBytes(response.getEntity().getContent()), StandardCharsets.UTF_8);
            resp = this.jsonMapper.fromJson(tmp, responseType);
        }
        catch (Exception e) {
            LOG.error("Failed DELETE with responseType {}, selector {}, key {}, due to {}", new Object[]{responseType, selector, key, e.getMessage()});
        }
        return resp;
    }

    private <T> String retrievePath(Class<T> clazz) {
        AtomicReference path = new AtomicReference();
        this.productMap.forEach((product, map) -> {
            if (map.containsKey(clazz)) {
                path.set((String)map.get(clazz));
            }
        });
        return (String)path.get();
    }

    private <T> Header retrieveToken(Class<T> clazz) {
        AtomicReference currentProduct = new AtomicReference();
        this.productMap.forEach((product, map) -> {
            if (map.containsKey(clazz)) {
                currentProduct.set(product);
            }
        });
        Map.Entry<String, String> header = this.authentication.getTokenHeader((Product)((Object)currentProduct.get()));
        return new BasicHeader(header.getKey(), (Object)header.getValue());
    }
}

