/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public abstract class JwtAuthentication
implements Authentication {
    private final JwtConfig jwtConfig;
    private final Map<Product, JwtToken> tokens = new HashMap<Product, JwtToken>();

    protected JwtAuthentication(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    public JwtConfig getJwtConfig() {
        return this.jwtConfig;
    }

    @Override
    public final void resetToken(Product product) {
        this.tokens.remove((Object)product);
    }

    @Override
    public final Map<String, String> getTokenHeader(Product product) {
        if (!this.tokens.containsKey((Object)product) || !this.isValid(this.tokens.get((Object)product))) {
            JwtToken newToken = this.generateToken(product, this.jwtConfig.getProduct(product));
            this.tokens.put(product, newToken);
        }
        return this.authHeader(this.tokens.get((Object)product).getToken());
    }

    protected abstract JwtToken generateToken(Product var1, JwtCredential var2);

    private Map<String, String> authHeader(String token) {
        return Map.of("Authorization", "Bearer " + token);
    }

    private boolean isValid(JwtToken jwtToken) {
        return jwtToken.getExpiry().isAfter(LocalDateTime.now().plusSeconds(30L));
    }

    protected static class JwtToken {
        private final String token;
        private final LocalDateTime expiry;

        public JwtToken(String token, LocalDateTime expiry) {
            this.token = token;
            this.expiry = expiry;
        }

        public String getToken() {
            return this.token;
        }

        public LocalDateTime getExpiry() {
            return this.expiry;
        }
    }
}

