/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.config.ConnectorConfigurationUtil;
import io.camunda.connector.impl.config.ConnectorPropertyResolver;
import io.camunda.connector.runtime.util.outbound.DefaultOutboundConnectorFactory;
import io.camunda.connector.runtime.util.outbound.OutboundConnectorFactory;
import io.camunda.zeebe.spring.client.connector.OutboundConnectorManager;
import io.camunda.zeebe.spring.client.connector.SpringConnectorPropertyResolver;
import io.camunda.zeebe.spring.client.connector.SpringSecretProvider;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(prefix="zeebe.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ConnectorConfiguration {
    @Bean
    public OutboundConnectorFactory outboundConnectorFactory() {
        return new DefaultOutboundConnectorFactory();
    }

    @Bean
    public OutboundConnectorManager outboundConnectorManager(JobWorkerManager jobWorkerManager, OutboundConnectorFactory outboundConnectorFactory) {
        return new OutboundConnectorManager(jobWorkerManager, outboundConnectorFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretProvider secretProvider(Environment env) {
        return new SpringSecretProvider(env);
    }

    @Bean
    public ConnectorPropertyResolver connectorPropertyResolver(Environment env) {
        SpringConnectorPropertyResolver springPropertyResolver = new SpringConnectorPropertyResolver(env);
        ConnectorConfigurationUtil.setCustomPropertyResolver((ConnectorPropertyResolver)springPropertyResolver);
        return springPropertyResolver;
    }
}

